/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.maven.wrapper.Downloader;
import org.apache.maven.wrapper.Logger;

public class DefaultDownloader
implements Downloader {
    private final String applicationName;
    private final String applicationVersion;

    public DefaultDownloader(String applicationName, String applicationVersion) {
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.configureProxyAuthentication();
        this.configureAuthentication();
    }

    private void configureProxyAuthentication() {
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        }
    }

    private void configureAuthentication() {
        if (System.getenv("MVNW_USERNAME") != null && System.getenv("MVNW_PASSWORD") != null && System.getProperty("http.proxyUser") == null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(System.getenv("MVNW_USERNAME"), System.getenv("MVNW_PASSWORD").toCharArray());
                }
            });
        }
    }

    @Override
    public void download(URI address, Path destination) throws Exception {
        if (Files.exists(destination, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        if (!"https".equals(address.getScheme())) {
            Logger.warn("Using an insecure connection to download the Maven distribution. Please consider using HTTPS.");
        }
        this.downloadInternal(address, destination);
    }

    private void downloadInternal(URI address, Path destination) throws IOException {
        URL url = address.toURL();
        URLConnection conn = url.openConnection();
        this.addBasicAuthentication(address, conn);
        String userAgentValue = this.calculateUserAgent();
        conn.setRequestProperty("User-Agent", userAgentValue);
        try (InputStream inStream = conn.getInputStream();){
            Files.copy(inStream, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void addBasicAuthentication(URI address, URLConnection connection) {
        String userInfo = this.calculateUserInfo(address);
        if (userInfo == null) {
            return;
        }
        connection.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private String base64Encode(String userInfo) {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Method getEncoderMethod = loader.loadClass("java.util.Base64").getMethod("getEncoder", new Class[0]);
            Method encodeMethod = loader.loadClass("java.util.Base64$Encoder").getMethod("encodeToString", byte[].class);
            Object encoder = getEncoderMethod.invoke(null, new Object[0]);
            return (String)encodeMethod.invoke(encoder, new Object[]{userInfo.getBytes(StandardCharsets.UTF_8)});
        }
        catch (Exception java7OrEarlier) {
            try {
                Method encodeMethod = loader.loadClass("javax.xml.bind.DatatypeConverter").getMethod("printBase64Binary", byte[].class);
                return (String)encodeMethod.invoke(null, new Object[]{userInfo.getBytes(StandardCharsets.UTF_8)});
            }
            catch (Exception java5OrEarlier) {
                throw new RuntimeException("Downloading Maven distributions with HTTP Basic Authentication is not supported on your JVM.", java5OrEarlier);
            }
        }
    }

    private String calculateUserInfo(URI uri) {
        String username = System.getenv("MVNW_USERNAME");
        String password = System.getenv("MVNW_PASSWORD");
        if (username != null && password != null) {
            return username + ':' + password;
        }
        return uri.getUserInfo();
    }

    private String calculateUserAgent() {
        String appVersion = this.applicationVersion;
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format(Locale.ROOT, "%s/%s (%s;%s;%s) (%s;%s;%s)", this.applicationName, appVersion, osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword", "").toCharArray());
        }
    }
}

