//package br.com.treinaweb.twjobs.api.files;
//
//import lombok.RequiredArgsConstructor;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.core.io.FileSystemResource;
//import org.springframework.core.io.InputStreamResource;
//import org.springframework.core.io.Resource;
//import org.springframework.http.HttpHeaders;
//import org.springframework.http.MediaType;
//import org.springframework.http.ResponseEntity;
//import org.springframework.ui.Model;
//import org.springframework.web.bind.annotation.*;
//import org.springframework.web.multipart.MultipartFile;
//
//import java.io.File;
//import java.io.IOException;
//import java.nio.file.DirectoryStream;
//import java.nio.file.Files;
//import java.nio.file.Path;
//import java.util.logging.Level;
//import java.util.logging.Logger;
//import java.util.stream.Collectors;
//import java.util.stream.StreamSupport;
//
//@RestController
////@RequiredArgsConstructor
////@RequestMapping("/api/files")
//public class FilaManagerController {
//
//    @Autowired
//    private FileStorageService fileStorageService;
//    private static final Logger log = Logger.getLogger(FilaManagerController.class.getName());
//
//    @PostMapping("/upload-file")
//    public boolean uploadFile(@RequestParam("file") MultipartFile file) {
//        try {
//            fileStorageService.saveFile(file);
//            return true;
//        } catch (IOException e) {
//            log.log(Level.SEVERE, "Exception during upload", e);
//        }
//        return false;
//    }
//
//    @GetMapping("/download")
//    public ResponseEntity<Resource> downloadFile(@RequestParam("fileName") String filename) {
//        log.log(Level.INFO, "[NORMAL] Download with /download");
//        try {
//            var fileToDownload = fileStorageService.getDownloadFile(filename);
//            return ResponseEntity.ok()
//                    .header(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + filename + "\"")
//                    .contentLength(fileToDownload.length())
//                    .contentType(MediaType.APPLICATION_OCTET_STREAM)
//                    .body(new InputStreamResource(Files.newInputStream(fileToDownload.toPath())));
//        } catch (Exception e) {
//            return ResponseEntity.notFound().build();
//        }
//    }
//
//
//
//
//
//
//
//    @GetMapping("/download-faster")
//    public ResponseEntity<Resource> downloadFileFaster(@RequestParam("fileName") String filename) {
//        log.log(Level.INFO, "[FASTER] Download with /download-faster");
//        try {
//            var fileToDownload = fileStorageService.getDownloadFile(filename);
//            return ResponseEntity.ok()
//                    .header(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + filename + "\"")
//                    .contentLength(fileToDownload.length())
//                    .contentType(MediaType.APPLICATION_OCTET_STREAM)
//                    .body(new FileSystemResource(fileToDownload));
//        } catch (Exception e) {
//            return ResponseEntity.notFound().build();
//        }
//    }
//
//}
