package br.com.treinaweb.twjobs.api.file;


import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;

@Service
public class FileStorageService {

    private static final String STORAGE_DIRECTORY = "..\\aceite-tecnico-backend\\src\\main\\arquivos";

    public void saveFile(MultipartFile fileToSave) throws IOException {

        if(fileToSave == null) {
            throw new NullPointerException("The file is null");
        }
        var targetFile = new File(STORAGE_DIRECTORY + File.separator + fileToSave.getOriginalFilename());
        if(!Objects.equals(targetFile.getParent(), STORAGE_DIRECTORY)){

            throw new SecurityException("Unsupported file name.");

        }

//        O getInputStream é o que salva o file
        Files.copy(fileToSave.getInputStream(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);


    }


    public File getDownloadFile(String fileName)  throws Exception{
        if(fileName == null){
            throw new NullPointerException("FileName is null");
        }
        var fileToDownload = new File(STORAGE_DIRECTORY + File.separator + fileName);
        if(!Objects.equals(fileToDownload.getParent(), STORAGE_DIRECTORY)) {
            throw new SecurityException("Unsupported fileName!");
        }
        if(!fileToDownload.exists()) {
            throw new FileNotFoundException("No file named:" + fileName);
        }

        return fileToDownload;
    }


}
