import { HttpClient, HttpParams } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { catchError, map, Observable, tap, throwError } from 'rxjs';
import { environment } from '../../../environments/.env'; // Importa o environment

@Injectable({
  providedIn: 'root'
})
export class UserService {
  private apiUrl = environment.API_URL + '/api/users'; // Usa a variável do environment
  private users: any; // Adicione a propriedade users

  constructor(private _http: HttpClient) {}

  getUserList(pageIndex: number, pageSize: number): Observable<any> {
    let params = new HttpParams()
      .set('page', pageIndex.toString())
      .set('size', pageSize.toString());

    return this._http.get<any>(`${this.apiUrl}`, { params }).pipe(
      tap((res: any) => {
        this.users = res; // Armazena os dados retornados
      }),
      catchError((error) => {
        console.error('Erro ao buscar lista de usuários:', error);
        return throwError(error); // Propaga o erro para ser tratado no componente
      })
    );
  }

  sendEmail(userId: number, sendEmail: boolean): Observable<any> {
    const url = `${this.apiUrl}/${userId}`; // Monta a URL para o usuário específico
    const body = { sendEmail: sendEmail ? 1 : 0 }; // Envia 1 para true e 0 para false

    return this._http.put<any>(url, body).pipe(
      tap(() => {
        console.log(`Email status atualizado para o usuário com ID: ${userId}`);
      }),
      catchError((error) => {
        console.error('Erro ao atualizar o status de envio de email:', error);
        return throwError(error); // Propaga o erro para ser tratado no componente
      })
    );
  }
  getAllAceitesSemPaginacao(): Observable<any[]> {
    return this._http.get<any>(`${this.apiUrl}/sem-paginacao`).pipe(
      map((res: any) => {
        // Ajuste conforme a estrutura do seu backend
        return res._embedded?.acceptResponseList || [];
      })
    );
  }
}
