import { Injectable } from '@angular/core';
import {
  HttpClient,
  HttpErrorResponse,
  HttpParams,
} from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, map, tap } from 'rxjs/operators';
import { environment } from '../../environments/.env'; // Importa o environment

@Injectable({
  providedIn: 'root',
})
export class NavioService {
  users: any[] = [];
  private apiUrl = environment.API_URL + '/api/vessels';
  private apiUrlDash = environment.API_URL + '/statistics/all';
  constructor(private _http: HttpClient) { }

  addEmployee1(data: any, foto: File): Observable<any> {
    console.log(JSON.stringify(JSON.stringify(data)));
    console.log(foto);

    // Cria uma instância de FormData
    const formData: FormData = new FormData();

    // Adiciona os dados JSON como uma string
    formData.append('vesselRequestForm', JSON.stringify(data));

    // Adiciona o arquivo PDF
    if (foto) {
      formData.append('foto', foto, foto.name);

    }

    return this._http.post(this.apiUrl, formData).pipe(
      tap((res: any) => {
        console.log('Resposta da API:', res);
      }),
      catchError(error => {
        console.error('Erro ao enviar dados:', error);
        return throwError(error);
      })
    );
  }

  dowloadNavio(data: any): Observable<any> {
    let params = new HttpParams();

    if (data.path) {
      params = params.set('fileName', data.path);
    }

    return this._http.get<any>(`${this.apiUrl}`, { params }).pipe(
      tap((res: any) => {
        console.log('Resultado recebido:', res);
      }),
      catchError((error) => {
        console.error('Erro ao buscar dados:', error);
        return throwError(error);
      })
    );
  }

  searchNavios(data: any): Observable<any> {
    let params = new HttpParams();

    // Adiciona os parâmetros de forma condicional (apenas se existirem)
    if (data.id) {
      params = params.set('id', data.id);
    }
    if (data.imo) {
      params = params.set('imo', data.imo);
    }
    if (data.dataInicio) {
      params = params.set('dataInicio', data.dataInicio);
    }
    if (data.dataFim) {
      params = params.set('dataFim', data.dataFim);
    }

    // Faz a requisição GET com os parâmetros
    return this._http.get<any>(`${this.apiUrl}/custom`, { params }).pipe(
      tap((res: any) => {
        console.log('Resultado recebido:', res);
        sessionStorage.setItem('naviosSearch', JSON.stringify(res));
      }),
      catchError((error) => {
        console.error('Erro ao buscar dados:', error);
        return throwError(error);
      })
    );
  }

  editEmployeeWithUpload(
    id: number,
    vesselRequest: any,
    foto: File | null
  ): Observable<any> {
    console.log('Dados para edição:', JSON.stringify(vesselRequest));
    console.log('Arquivo enviado:', foto);

    // Cria uma instância de FormData
    const formData: FormData = new FormData();

    // Adiciona os dados JSON como uma string
    formData.append('vesselRequestForm', JSON.stringify(vesselRequest));

    // Adiciona o arquivo, se disponível
    if (foto) {
      formData.append('foto', foto, foto.name);
    }

    // Faz a requisição POST ou PUT dependendo da API
    return this._http.put(`${this.apiUrl}/${id}`, formData).pipe(
      tap((res: any) => {
        console.log('Resposta da API (upload/edit):', res);
      }),
      catchError((error) => {
        console.error('Erro no upload/edição:', error);
        return throwError(error);
      })
    );
  }

  getEmployeeList(pageIndex: number, pageSize: number): Observable<any> {
    let params = new HttpParams()
      .set('page', pageIndex.toString())
      .set('size', pageSize.toString())
      .set('sort', 'id,desc');

    return this._http.get<any>(this.apiUrl, { params }).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError((error) => {
        return throwError(error);
      })
    );
  }

  deleteEmployee(id: number): Observable<any> {
    return this._http.delete(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError((error) => {
        return throwError(error);
      })
    );
  }

  // Novo método para obter um empregado por ID
  getEmployeeById(id: number): Observable<any> {
    return this._http.get<any>(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        console.log('Navio obtido:', res);
      }),
      catchError((error) => {
        console.error('Erro ao buscar empregado por ID:', error);
        return throwError(error);
      })
    );
  }
  getDadosDah(): Observable<any> {
    return this._http.get<any>(`${this.apiUrlDash}`).pipe(
      tap((res: any) => {
        console.log('dados Dash:', res);
      }),
      catchError((error) => {
        console.error('Erro ao buscar empregado por ID:', error);
        return throwError(error);
      })
    );
  }
getAllAceitesSemPaginacao(): Observable<any[]> {
  return this._http.get<any>(`${this.apiUrl}/sem-paginacao`).pipe(
    map((res: any) => res._embedded?.vesselResponseList || [])
  );
}




}
