import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { NavioService } from '../../../services/navio.service';
import { CoreService } from '../../../core/core.service';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatSelectModule } from '@angular/material/select';
import { MatRadioModule } from '@angular/material/radio';
import { MatIconModule } from '@angular/material/icon'; // Corrigido
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatDialogModule } from '@angular/material/dialog';
import { ToastrService } from 'ngx-toastr';
import { BercosComponent } from '../bercos/bercos.component';
import { BercosService } from '../../../services/bercos/bercos.service';

@Component({
  selector: 'app-berco-add',
  standalone: true,
  imports: [
    MatDialogModule,
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatInputModule,
    MatFormFieldModule,
    MatDatepickerModule,
    MatSelectModule,
    MatRadioModule,
    MatIconModule,
    MatSnackBarModule,
    BercosComponent,
  ],  templateUrl: './berco-add.component.html',
  styleUrl: './berco-add.component.scss'
})
export class BercoAddComponent implements OnInit {
  bercoForm: FormGroup;
  categoria = [
    { id: 1, nome: 'Granel Sólido' },
    { id: 2, nome: 'Granel Líquido' },
    { id: 3, nome: 'Carga Geral' }
  ];
  constructor(
    private _fb: FormBuilder,
    private _bercoService: BercosService,
    private _dialogRef: MatDialogRef<BercoAddComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private toastService: ToastrService,
  ) {
    this.bercoForm = this._fb.group({
      nome: ['', Validators.required],
      compri_estrutural: ['', Validators.required],
      compri_util: ['', Validators.required],
      dwt: ['', Validators.required],
      largura: ['', Validators.required],
      profundidade: ['', Validators.required],
      calado_max: ['', Validators.required],
      boca_max: ['', Validators.required],
      loa_max: ['', Validators.required],
      categoria:['', Validators.required]
    });
  }

  preventNegative(event: KeyboardEvent): void {
    if (event.key === '-' || event.key === '+' || event.key === 'e') {
      event.preventDefault();
    }
  }

  ngOnInit(): void {
    if (this.data) {
      this.bercoForm.patchValue(this.data.bercoForm);
    }
  }

  getErrorMessage(formControlName: string): string {
    if (this.bercoForm.get(formControlName)?.hasError('required')) {
      return 'Campo obrigatório';
    }
    return '';
  }

  onFormSubmit() {
    if (this.bercoForm.valid) {
      console.log(this.bercoForm.value)
      this._bercoService.addEmployee(this.bercoForm.value).subscribe({
        next: (val: any) => {
          this.toastService.success('Berço adicionado com sucesso');
          this._dialogRef.close(true);
        },
        error: (err: any) => {
          console.error(err);
        }
      });
    }
  }
}