import { HttpInterceptorFn } from '@angular/common/http';
import { jwtDecode } from 'jwt-decode';

export const customInterceptor: HttpInterceptorFn = (req, next) => {
  const myToken = sessionStorage.getItem('accessToken');
  if (myToken){
    const decodedToken = jwtDecode(myToken);
    const isExpired = 
      decodedToken && decodedToken.exp? decodedToken.exp < Date.now()/1000:false
    if(isExpired){
      sessionStorage.removeItem('accessToken');
    }
    const clonedRequest = req.clone({
      setHeaders: {
        Authorization: `Bearer ${myToken}`
      }
    });
    return next(clonedRequest);
  }
  return next(req);
};
