import { HttpClient, HttpErrorResponse, HttpParams } from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, tap } from 'rxjs/operators';
import { AsyncValidatorFn, AbstractControl, ValidationErrors, Validators } from '@angular/forms';
import { map } from 'rxjs/operators';
import { Injectable } from '@angular/core';
import { of } from 'rxjs';
import { environment } from '../../../environments/.env'; // Importa o environment
@Injectable({
  providedIn: 'root'
})
export class AceiteService {
  users: any[] = [];

  private apiUrl = environment.API_URL + '/api/accepts';
  private apiUrl_verifica_imo = environment.API_URL + '/api/vdatas';


  constructor(private _http: HttpClient) { }


getAllAceitesSemPaginacao(): Observable<any[]> {
  return this._http.get<any>(`${this.apiUrl}/sem-paginacao`).pipe(
    map((res: any) => {
      // Ajuste conforme a estrutura do seu backend
      return res._embedded?.acceptResponseList || [];
    })
  );
}
  addAceite(data: any, foto: File | null): Observable<any> {
    console.log(JSON.stringify(JSON.stringify(data)));
    console.log(foto);

    // Cria uma instância de FormData
    const formData: FormData = new FormData();

    // Adiciona os dados JSON como uma string
    formData.append('acceptRequestForm', JSON.stringify(data));

    // Adiciona o arquivo PDF
    if (foto) {
      formData.append('foto', foto, foto.name);

    }

    return this._http.post(this.apiUrl, formData).pipe(
      tap((res: any) => {
        console.log('Resposta da API:', res);
      }),
      catchError(error => {
        console.error('Erro ao enviar dados:', error);
        return throwError(error);
      })
    );
  }
  editAceite(id: number, data: any, foto: File): Observable<any> {
    console.log('Dados para edição:', JSON.stringify(data));
    console.log('Arquivo enviado:', foto);

    // Cria uma instância de FormData
    const formData: FormData = new FormData();

    // Adiciona os dados JSON como uma string
    formData.append('acceptRequestForm', JSON.stringify(data));

    // Adiciona o arquivo, se disponível
    if (foto) {
      formData.append('foto', foto, foto.name);
    }

    // Faz a requisição POST ou PUT dependendo do backend
    return this._http.post(`${this.apiUrl}/upload/${id}`, formData).pipe(
      tap((res: any) => {
        console.log('Resposta da API (edição com upload):', res);
      }),
      catchError(error => {
        console.error('Erro no upload/edição:', error);
        return throwError(error);
      })
    );
  }

  searchAceite(data: any): Observable<any> {
    let params = new HttpParams();

    // Adiciona os parâmetros de forma condicional (apenas se existirem)
    if (data.id) {
      params = params.set('id', data.id);
    }
    if (data.imo) {
      params = params.set('imo', data.imo);
    }
    if (data.dataInicio) {
    params = params.set('dataInicio', data.dataInicio);
  }
  if (data.dataFim) {
    params = params.set('dataFim', data.dataFim);
  }
    // Faz a requisição GET com os parâmetros
    return this._http.get<any>(`${this.apiUrl}/custom`, { params }).pipe(
      tap((res: any) => {
        console.log('Resultado recebido:', res);
        sessionStorage.setItem("aceitesSearch", JSON.stringify(res));
      }),
      catchError(error => {
        console.error('Erro ao buscar dados:', error);
        return throwError(error);
      })
    );
  }


  updateAceite(id: number, data: any, foto: File | null): Observable<any> {
    console.log('Dados para atualização:', JSON.stringify(data));
    console.log('Arquivo enviado:', foto);

    // Cria uma instância de FormData
    const formData: FormData = new FormData();

    // Adiciona os dados JSON como uma string
    formData.append('acceptRequestForm', JSON.stringify(data));

    // Adiciona o arquivo, se disponível
    if (foto) {
      formData.append('foto', foto, foto.name);
    }

    // Faz a requisição PUT para atualizar os dados
    return this._http.put(`${this.apiUrl}/${id}`, formData).pipe(
      tap((res: any) => {
        console.log('Resposta da API (update):', res);
      }),
      catchError(error => {
        console.error('Erro ao atualizar dados:', error);
        return throwError(error);
      })
    );
  }


  getAceiteList(pageIndex: number, pageSize: number): Observable<any> {
    let params = new HttpParams()
      .set('page', pageIndex.toString())
      .set('size', pageSize.toString());

    return this._http.get<any>(this.apiUrl, { params }).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  getAceiteListbyId(id: number): Observable<any> {
    return this._http.get(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  getEmployeebyIMO(imo: number): Observable<any> {
    return this._http.get(`${this.apiUrl_verifica_imo}/${imo}`).pipe(
      tap((res: any) => {
        console.log(res)
        this.users = res;
      }),
      catchError(error => {
        console.log(error)
        return throwError(error);
      })
    );
  }

  deleteEmployee(id: number): Observable<any> {
    return this._http.delete(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      }));
  }
}
