import { Routes } from '@angular/router';
import { LoginComponent } from './pages/login/login.component';
import { SignUpComponent } from './pages/signup/signup.component';
import { UserComponent } from './pages/user/user.component';
import { AuthGuardService } from './services/auth-guard.service';
import { NaviosComponent } from './pages/crud-navios/navios/navios.component';
import { IsAdminService } from './services/is-admin.service';
import { DashboardComponent } from './pages/dashboard/dashboard.component';
import { AceitesComponent } from './pages/crud-aceites/aceites/aceites.component';
import { LoginSignupService } from './login-signup.service';
import { BercosComponent } from './pages/crud-bercos/bercos/bercos.component';
import { BlackListComponent } from './pages/crud-blackList/black-list/black-list.component';   
export const routes: Routes = [
    {
        path: "",
        component: LoginComponent,
        canActivate: [LoginSignupService]
    },
    {
        path: "signup",
        component: SignUpComponent,
        canActivate: [LoginSignupService]
    },
    {
        path:'navio',
        component: NaviosComponent,
        canActivate: [AuthGuardService]
    },
    {
        path:'dashboard',
        component: DashboardComponent,
        canActivate: [AuthGuardService,IsAdminService]
    },
    {
        path:'aceite',
        component: AceitesComponent,
        canActivate: [AuthGuardService]
    },
    {
        path:'berco',
        component: BercosComponent,
        canActivate: [AuthGuardService]
    },
    {
        path:'black-list',
        component: BlackListComponent,
        canActivate:[AuthGuardService,IsAdminService]
        
    },
    {
        path:'users',
        component: UserComponent,
        canActivate:[AuthGuardService,IsAdminService]
        
    }
];
