import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class AuthService {
  private authTokenSubject = new BehaviorSubject<boolean>(this.checkAuthToken());

  authToken$ = this.authTokenSubject.asObservable();

  constructor() {}

  private checkAuthToken(): boolean {
    const authToken = sessionStorage.getItem('accessToken');
    return !!authToken;
  }

  updateAuthTokenStatus(isLoggedIn: boolean) {
    this.authTokenSubject.next(isLoggedIn);
  }
}
