import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { NavioService } from '../../../services/navio.service';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatSelectModule } from '@angular/material/select';
import { MatRadioModule } from '@angular/material/radio';
import { MatIconModule } from '@angular/material/icon'; // Corrigido
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatDialogModule } from '@angular/material/dialog';
import { NaviosComponent } from '../navios/navios.component';
import { ToastrService } from 'ngx-toastr';
import { NgxCurrencyDirective } from 'ngx-currency';
import { BercosService } from '../../../services/bercos/bercos.service';

@Component({
  selector: 'app-navio-add',
  standalone: true,
  imports: [
    MatDialogModule,
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatInputModule,
    MatFormFieldModule,
    MatDatepickerModule,
    MatSelectModule,
    MatRadioModule,
    MatIconModule,
    MatSnackBarModule,
    NaviosComponent,
    NgxCurrencyDirective,
  ],
  templateUrl: './navio-add.component.html',
  styleUrl: './navio-add.component.scss',
})
export class NavioAddComponent implements OnInit {
  fileName = '';
  imageUrl: string | ArrayBuffer | null = '';
  empForm: FormGroup;
  selectedFile: File | null = null;

  categoria = [
    { id: 1, nome: 'Granel Sólido' },
    { id: 2, nome: 'Granel Líquido' },
    { id: 3, nome: 'Carga Geral' }
  ];
  constructor(
    private _fb: FormBuilder,
    private _empService: NavioService,
    private _dialogRef: MatDialogRef<NavioAddComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private toastService: ToastrService,
    private _bercoService: BercosService, // Injetando o serviço de berços
  ) {
    this.empForm = this._fb.group({
      imo: ['', Validators.required],
      mmsi: ['', Validators.required],
      nome: ['', Validators.required],
      loa: ['', Validators.required],
      boca: ['', Validators.required],
      dwt: ['', Validators.required],
      pontal: ['', Validators.required],
      ponte_mfold: ['', Validators.required],
      mfold_quilha: ['', Validators.required],
      categoria: ['', Validators.required],
      flag: ['', Validators.required],
      calado_max: ['', Validators.required],

      obs: [''],
    });
    this.empForm.get('categoria')?.valueChanges.subscribe(catId => {
  const cat = this.categoria.find((c: any) => c.id === catId);
  if (cat && cat.nome === 'Granel Líquido') {
    this.empForm.get('mfold_quilha')?.setValidators([Validators.required]);
    this.empForm.get('ponte_mfold')?.setValidators([Validators.required]);
  } else {
    this.empForm.get('mfold_quilha')?.clearValidators();
    this.empForm.get('ponte_mfold')?.clearValidators();
  }
  this.empForm.get('mfold_quilha')?.updateValueAndValidity();
  this.empForm.get('ponte_mfold')?.updateValueAndValidity();
});
  }
selectedCategoriaNome: string = '';

  onCategoriaChange(catId: any) {
    const cat = this.categoria.find((c: any) => c.id === catId);
    this.selectedCategoriaNome = cat ? cat.nome : '';
  }

  countries = [   { id: 1, name: 'Afeganistão', flagUrl: 'https://flagcdn.com/w20/af.png' },
  { id: 2, name: 'Albânia', flagUrl: 'https://flagcdn.com/w20/al.png' },
  { id: 3, name: 'Alemanha', flagUrl: 'https://flagcdn.com/w20/de.png' },
  { id: 4, name: 'Andorra', flagUrl: 'https://flagcdn.com/w20/ad.png' },
  { id: 5, name: 'Angola', flagUrl: 'https://flagcdn.com/w20/ao.png' },
  { id: 6, name: 'Anguila', flagUrl: 'https://flagcdn.com/w20/ai.png' },
  { id: 7, name: 'Antártida', flagUrl: 'https://flagcdn.com/w20/aq.png' },
  { id: 8, name: 'Antígua e Barbuda', flagUrl: 'https://flagcdn.com/w20/ag.png' },
  { id: 9, name: 'Argentina', flagUrl: 'https://flagcdn.com/w20/ar.png' },
  { id: 10, name: 'Argélia', flagUrl: 'https://flagcdn.com/w20/dz.png' },
  { id: 11, name: 'Armênia', flagUrl: 'https://flagcdn.com/w20/am.png' },
  { id: 12, name: 'Aruba', flagUrl: 'https://flagcdn.com/w20/aw.png' },
  { id: 13, name: 'Arábia Saudita', flagUrl: 'https://flagcdn.com/w20/sa.png' },
  { id: 14, name: 'Austrália', flagUrl: 'https://flagcdn.com/w20/au.png' },
  { id: 15, name: 'Azerbaijão', flagUrl: 'https://flagcdn.com/w20/az.png' },
  { id: 16, name: 'Bahamas', flagUrl: 'https://flagcdn.com/w20/bs.png' },
  { id: 17, name: 'Bangladesh', flagUrl: 'https://flagcdn.com/w20/bd.png' },
  { id: 18, name: 'Barbados', flagUrl: 'https://flagcdn.com/w20/bb.png' },
  { id: 19, name: 'Barein', flagUrl: 'https://flagcdn.com/w20/bh.png' },
  { id: 20, name: 'Belize', flagUrl: 'https://flagcdn.com/w20/bz.png' },
  { id: 21, name: 'Benin', flagUrl: 'https://flagcdn.com/w20/bj.png' },
  { id: 22, name: 'Bermudas', flagUrl: 'https://flagcdn.com/w20/bm.png' },
  { id: 23, name: 'Bielorrússia', flagUrl: 'https://flagcdn.com/w20/by.png' },
  { id: 24, name: 'Bolívia', flagUrl: 'https://flagcdn.com/w20/bo.png' },
  { id: 25, name: 'Botsuana', flagUrl: 'https://flagcdn.com/w20/bw.png' },
  { id: 26, name: 'Brasil', flagUrl: 'https://flagcdn.com/w20/br.png' },
  { id: 27, name: 'Brunei', flagUrl: 'https://flagcdn.com/w20/bn.png' },
  { id: 28, name: 'Bulgária', flagUrl: 'https://flagcdn.com/w20/bg.png' },
  { id: 29, name: 'Burquina Faso', flagUrl: 'https://flagcdn.com/w20/bf.png' },
  { id: 30, name: 'Burundi', flagUrl: 'https://flagcdn.com/w20/bi.png' },
  { id: 31, name: 'Butão', flagUrl: 'https://flagcdn.com/w20/bt.png' },
  { id: 32, name: 'Bélgica', flagUrl: 'https://flagcdn.com/w20/be.png' },
  { id: 33, name: 'Bósnia e Herzegovina', flagUrl: 'https://flagcdn.com/w20/ba.png' },
  { id: 34, name: 'Cabo Verde', flagUrl: 'https://flagcdn.com/w20/cv.png' },
  { id: 35, name: 'Camarões', flagUrl: 'https://flagcdn.com/w20/cm.png' },
  { id: 36, name: 'Camboja', flagUrl: 'https://flagcdn.com/w20/kh.png' },
  { id: 37, name: 'Canadá', flagUrl: 'https://flagcdn.com/w20/ca.png' },
  { id: 38, name: 'Catar', flagUrl: 'https://flagcdn.com/w20/qa.png' },
  { id: 39, name: 'Cazaquistão', flagUrl: 'https://flagcdn.com/w20/kz.png' },
  { id: 40, name: 'Chade', flagUrl: 'https://flagcdn.com/w20/td.png' },
  { id: 41, name: 'Chile', flagUrl: 'https://flagcdn.com/w20/cl.png' },
  { id: 42, name: 'China', flagUrl: 'https://flagcdn.com/w20/cn.png' },
  { id: 43, name: 'Chipre', flagUrl: 'https://flagcdn.com/w20/cy.png' },
  { id: 44, name: 'Cidade do Vaticano', flagUrl: 'https://flagcdn.com/w20/va.png' },
  { id: 45, name: 'Colômbia', flagUrl: 'https://flagcdn.com/w20/co.png' },
  { id: 46, name: 'Comores', flagUrl: 'https://flagcdn.com/w20/km.png' },
  { id: 47, name: 'Congo - Kinshasa', flagUrl: 'https://flagcdn.com/w20/cd.png' },
  { id: 48, name: 'Coreia do Norte', flagUrl: 'https://flagcdn.com/w20/kp.png' },
  { id: 49, name: 'Coreia do Sul', flagUrl: 'https://flagcdn.com/w20/kr.png' },
  { id: 50, name: 'Costa Rica', flagUrl: 'https://flagcdn.com/w20/cr.png' },
  { id: 51, name: 'Costa do Marfim', flagUrl: 'https://flagcdn.com/w20/ci.png' },
  { id: 52, name: 'Croácia', flagUrl: 'https://flagcdn.com/w20/hr.png' },
  { id: 53, name: 'Cuba', flagUrl: 'https://flagcdn.com/w20/cu.png' },
  { id: 54, name: 'Curaçao', flagUrl: 'https://flagcdn.com/w20/cw.png' },
  { id: 55, name: 'Dinamarca', flagUrl: 'https://flagcdn.com/w20/dk.png' },
  { id: 56, name: 'Djibuti', flagUrl: 'https://flagcdn.com/w20/dj.png' },
  { id: 57, name: 'Dominica', flagUrl: 'https://flagcdn.com/w20/dm.png' },
  { id: 58, name: 'Egito', flagUrl: 'https://flagcdn.com/w20/eg.png' },
  { id: 59, name: 'El Salvador', flagUrl: 'https://flagcdn.com/w20/sv.png' },
  { id: 60, name: 'Emirados Árabes Unidos', flagUrl: 'https://flagcdn.com/w20/ae.png' },
  { id: 61, name: 'Equador', flagUrl: 'https://flagcdn.com/w20/ec.png' },
  { id: 62, name: 'Eritreia', flagUrl: 'https://flagcdn.com/w20/er.png' },
  { id: 63, name: 'Eslováquia', flagUrl: 'https://flagcdn.com/w20/sk.png' },
  { id: 64, name: 'Eslovênia', flagUrl: 'https://flagcdn.com/w20/si.png' },
  { id: 65, name: 'Espanha', flagUrl: 'https://flagcdn.com/w20/es.png' },
  { id: 66, name: 'Essuatíni', flagUrl: 'https://flagcdn.com/w20/sz.png' },
  { id: 67, name: 'Estados Unidos', flagUrl: 'https://flagcdn.com/w20/us.png' },
  { id: 68, name: 'Estônia', flagUrl: 'https://flagcdn.com/w20/ee.png' },
  { id: 69, name: 'Etiópia', flagUrl: 'https://flagcdn.com/w20/et.png' },
  { id: 70, name: 'Fiji', flagUrl: 'https://flagcdn.com/w20/fj.png' },
  { id: 71, name: 'Filipinas', flagUrl: 'https://flagcdn.com/w20/ph.png' },
  { id: 72, name: 'Finlândia', flagUrl: 'https://flagcdn.com/w20/fi.png' },
  { id: 73, name: 'França', flagUrl: 'https://flagcdn.com/w20/fr.png' },
  { id: 74, name: 'Gabão', flagUrl: 'https://flagcdn.com/w20/ga.png' },
  { id: 75, name: 'Gana', flagUrl: 'https://flagcdn.com/w20/gh.png' },
  { id: 76, name: 'Geórgia', flagUrl: 'https://flagcdn.com/w20/ge.png' },
  { id: 77, name: 'Gibraltar', flagUrl: 'https://flagcdn.com/w20/gi.png' },
  { id: 78, name: 'Granada', flagUrl: 'https://flagcdn.com/w20/gd.png' },
  { id: 79, name: 'Groenlândia', flagUrl: 'https://flagcdn.com/w20/gl.png' },
  { id: 80, name: 'Grécia', flagUrl: 'https://flagcdn.com/w20/gr.png' },
  { id: 81, name: 'Guadalupe', flagUrl: 'https://flagcdn.com/w20/gp.png' },
  { id: 82, name: 'Guam', flagUrl: 'https://flagcdn.com/w20/gu.png' },
  { id: 83, name: 'Guatemala', flagUrl: 'https://flagcdn.com/w20/gt.png' },
  { id: 84, name: 'Guernsey', flagUrl: 'https://flagcdn.com/w20/gg.png' },
  { id: 85, name: 'Guiana', flagUrl: 'https://flagcdn.com/w20/gy.png' },
  { id: 86, name: 'Guiana Francesa', flagUrl: 'https://flagcdn.com/w20/gf.png' },
  { id: 87, name: 'Guiné', flagUrl: 'https://flagcdn.com/w20/gn.png' },
  { id: 88, name: 'Guiné Equatorial', flagUrl: 'https://flagcdn.com/w20/gq.png' },
  { id: 89, name: 'Guiné-Bissau', flagUrl: 'https://flagcdn.com/w20/gw.png' },
  { id: 90, name: 'Gâmbia', flagUrl: 'https://flagcdn.com/w20/gm.png' },
  { id: 91, name: 'Haiti', flagUrl: 'https://flagcdn.com/w20/ht.png' },
  { id: 92, name: 'Honduras', flagUrl: 'https://flagcdn.com/w20/hn.png' },
  { id: 93, name: 'Hong Kong, RAE da China', flagUrl: 'https://flagcdn.com/w20/hk.png' },
  { id: 94, name: 'Hungria', flagUrl: 'https://flagcdn.com/w20/hu.png' },
  { id: 95, name: 'Ilha Bouvet', flagUrl: 'https://flagcdn.com/w20/bv.png' },
  { id: 96, name: 'Ilha Christmas', flagUrl: 'https://flagcdn.com/w20/cx.png' },
  { id: 97, name: 'Ilha Norfolk', flagUrl: 'https://flagcdn.com/w20/nf.png' },
  { id: 98, name: 'Ilha de Man', flagUrl: 'https://flagcdn.com/w20/im.png' },
  { id: 99, name: 'Ilhas Aland', flagUrl: 'https://flagcdn.com/w20/ax.png' },
  { id: 100, name: 'Ilhas Cayman', flagUrl: 'https://flagcdn.com/w20/ky.png' },
  { id: 101, name: 'Ilhas Cocos (Keeling)', flagUrl: 'https://flagcdn.com/w20/cc.png' },
  { id: 102, name: 'Ilhas Cook', flagUrl: 'https://flagcdn.com/w20/ck.png' },
  { id: 103, name: 'Ilhas Faroé', flagUrl: 'https://flagcdn.com/w20/fo.png' },
  { id: 104, name: 'Ilhas Geórgia do Sul e Sandwich do Sul', flagUrl: 'https://flagcdn.com/w20/gs.png' },
  { id: 105, name: 'Ilhas Heard e McDonald', flagUrl: 'https://flagcdn.com/w20/hm.png' },
  { id: 106, name: 'Ilhas Malvinas', flagUrl: 'https://flagcdn.com/w20/fk.png' },
  { id: 107, name: 'Ilhas Marianas do Norte', flagUrl: 'https://flagcdn.com/w20/mp.png' },
  { id: 108, name: 'Ilhas Marshall', flagUrl: 'https://flagcdn.com/w20/mh.png' },
  { id: 109, name: 'Ilhas Menores Distantes dos EUA', flagUrl: 'https://flagcdn.com/w20/um.png' },
  { id: 110, name: 'Ilhas Pitcairn', flagUrl: 'https://flagcdn.com/w20/pn.png' },
  { id: 111, name: 'Ilhas Salomão', flagUrl: 'https://flagcdn.com/w20/sb.png' },
  { id: 112, name: 'Ilhas Turcas e Caicos', flagUrl: 'https://flagcdn.com/w20/tc.png' },
  { id: 113, name: 'Ilhas Virgens Americanas', flagUrl: 'https://flagcdn.com/w20/vi.png' },
  { id: 114, name: 'Ilhas Virgens Britânicas', flagUrl: 'https://flagcdn.com/w20/vg.png' },
  { id: 115, name: 'Indonésia', flagUrl: 'https://flagcdn.com/w20/id.png' },
  { id: 116, name: 'Iraque', flagUrl: 'https://flagcdn.com/w20/iq.png' },
  { id: 117, name: 'Irlanda', flagUrl: 'https://flagcdn.com/w20/ie.png' },
  { id: 118, name: 'Irã', flagUrl: 'https://flagcdn.com/w20/ir.png' },
  { id: 119, name: 'Islândia', flagUrl: 'https://flagcdn.com/w20/is.png' },
  { id: 120, name: 'Israel', flagUrl: 'https://flagcdn.com/w20/il.png' },
  { id: 121, name: 'Itália', flagUrl: 'https://flagcdn.com/w20/it.png' },
  { id: 122, name: 'Iêmen', flagUrl: 'https://flagcdn.com/w20/ye.png' },
  { id: 123, name: 'Jamaica', flagUrl: 'https://flagcdn.com/w20/jm.png' },
  { id: 124, name: 'Japão', flagUrl: 'https://flagcdn.com/w20/jp.png' },
  { id: 125, name: 'Jersey', flagUrl: 'https://flagcdn.com/w20/je.png' },
  { id: 126, name: 'Jordânia', flagUrl: 'https://flagcdn.com/w20/jo.png' },
  { id: 127, name: 'Kuwait', flagUrl: 'https://flagcdn.com/w20/kw.png' },
  { id: 128, name: 'Laos', flagUrl: 'https://flagcdn.com/w20/la.png' },
  { id: 129, name: 'Lesoto', flagUrl: 'https://flagcdn.com/w20/ls.png' },
  { id: 130, name: 'Letônia', flagUrl: 'https://flagcdn.com/w20/lv.png' },
  { id: 131, name: 'Libéria', flagUrl: 'https://flagcdn.com/w20/lr.png' },
  { id: 132, name: 'Liechtenstein', flagUrl: 'https://flagcdn.com/w20/li.png' },
  { id: 133, name: 'Lituânia', flagUrl: 'https://flagcdn.com/w20/lt.png' },
  { id: 134, name: 'Luxemburgo', flagUrl: 'https://flagcdn.com/w20/lu.png' },
  { id: 135, name: 'Líbano', flagUrl: 'https://flagcdn.com/w20/lb.png' },
  { id: 136, name: 'Líbia', flagUrl: 'https://flagcdn.com/w20/ly.png' },
  { id: 137, name: 'Macau, RAE da China', flagUrl: 'https://flagcdn.com/w20/mo.png' },
  { id: 138, name: 'Macedônia do Norte', flagUrl: 'https://flagcdn.com/w20/mk.png' },
  { id: 139, name: 'Madagascar', flagUrl: 'https://flagcdn.com/w20/mg.png' },
  { id: 140, name: 'Malaui', flagUrl: 'https://flagcdn.com/w20/mw.png' },
  { id: 141, name: 'Maldivas', flagUrl: 'https://flagcdn.com/w20/mv.png' },
  { id: 142, name: 'Mali', flagUrl: 'https://flagcdn.com/w20/ml.png' },
  { id: 143, name: 'Malta', flagUrl: 'https://flagcdn.com/w20/mt.png' },
  { id: 144, name: 'Malásia', flagUrl: 'https://flagcdn.com/w20/my.png' },
  { id: 145, name: 'Marrocos', flagUrl: 'https://flagcdn.com/w20/ma.png' },
  { id: 146, name: 'Martinica', flagUrl: 'https://flagcdn.com/w20/mq.png' },
  { id: 147, name: 'Mauritânia', flagUrl: 'https://flagcdn.com/w20/mr.png' },
  { id: 148, name: 'Maurício', flagUrl: 'https://flagcdn.com/w20/mu.png' },
  { id: 149, name: 'Mayotte', flagUrl: 'https://flagcdn.com/w20/yt.png' },
  { id: 150, name: 'Mianmar (Birmânia)', flagUrl: 'https://flagcdn.com/w20/mm.png' },
  { id: 151, name: 'Micronésia', flagUrl: 'https://flagcdn.com/w20/fm.png' },
  { id: 152, name: 'Moldávia', flagUrl: 'https://flagcdn.com/w20/md.png' },
  { id: 153, name: 'Mongólia', flagUrl: 'https://flagcdn.com/w20/mn.png' },
  { id: 154, name: 'Montenegro', flagUrl: 'https://flagcdn.com/w20/me.png' },
  { id: 155, name: 'Montserrat', flagUrl: 'https://flagcdn.com/w20/ms.png' },
  { id: 156, name: 'Moçambique', flagUrl: 'https://flagcdn.com/w20/mz.png' },
  { id: 157, name: 'México', flagUrl: 'https://flagcdn.com/w20/mx.png' },
  { id: 158, name: 'Mônaco', flagUrl: 'https://flagcdn.com/w20/mc.png' },
  { id: 159, name: 'Namíbia', flagUrl: 'https://flagcdn.com/w20/na.png' },
  { id: 160, name: 'Nauru', flagUrl: 'https://flagcdn.com/w20/nr.png' },
  { id: 161, name: 'Nepal', flagUrl: 'https://flagcdn.com/w20/np.png' },
  { id: 162, name: 'Nicarágua', flagUrl: 'https://flagcdn.com/w20/ni.png' },
  { id: 163, name: 'Nigéria', flagUrl: 'https://flagcdn.com/w20/ng.png' },
  { id: 164, name: 'Niue', flagUrl: 'https://flagcdn.com/w20/nu.png' },
  { id: 165, name: 'Noruega', flagUrl: 'https://flagcdn.com/w20/no.png' },
  { id: 166, name: 'Nova Caledônia', flagUrl: 'https://flagcdn.com/w20/nc.png' },
  { id: 167, name: 'Nova Zelândia', flagUrl: 'https://flagcdn.com/w20/nz.png' },
  { id: 168, name: 'Níger', flagUrl: 'https://flagcdn.com/w20/ne.png' },
  { id: 169, name: 'Omã', flagUrl: 'https://flagcdn.com/w20/om.png' },
  { id: 170, name: 'Palau', flagUrl: 'https://flagcdn.com/w20/pw.png' },
  { id: 171, name: 'Panamá', flagUrl: 'https://flagcdn.com/w20/pa.png' },
  { id: 172, name: 'Papua-Nova Guiné', flagUrl: 'https://flagcdn.com/w20/pg.png' },
  { id: 173, name: 'Paquistão', flagUrl: 'https://flagcdn.com/w20/pk.png' },
  { id: 174, name: 'Paraguai', flagUrl: 'https://flagcdn.com/w20/py.png' },
  { id: 175, name: 'Países Baixos', flagUrl: 'https://flagcdn.com/w20/nl.png' },
  { id: 176, name: 'Países Baixos Caribenhos', flagUrl: 'https://flagcdn.com/w20/bq.png' },
  { id: 177, name: 'Peru', flagUrl: 'https://flagcdn.com/w20/pe.png' },
  { id: 178, name: 'Polinésia Francesa', flagUrl: 'https://flagcdn.com/w20/pf.png' },
  { id: 179, name: 'Polônia', flagUrl: 'https://flagcdn.com/w20/pl.png' },
  { id: 180, name: 'Porto Rico', flagUrl: 'https://flagcdn.com/w20/pr.png' },
  { id: 181, name: 'Portugal', flagUrl: 'https://flagcdn.com/w20/pt.png' },
  { id: 182, name: 'Quirguistão', flagUrl: 'https://flagcdn.com/w20/kg.png' },
  { id: 183, name: 'Quiribati', flagUrl: 'https://flagcdn.com/w20/ki.png' },
  { id: 184, name: 'Quênia', flagUrl: 'https://flagcdn.com/w20/ke.png' },
  { id: 185, name: 'Reino Unido', flagUrl: 'https://flagcdn.com/w20/gb.png' },
  { id: 186, name: 'República Centro-Africana', flagUrl: 'https://flagcdn.com/w20/cf.png' },
  { id: 187, name: 'República Dominicana', flagUrl: 'https://flagcdn.com/w20/do.png' },
  { id: 188, name: 'República do Congo', flagUrl: 'https://flagcdn.com/w20/cg.png' },
  { id: 189, name: 'Reunião', flagUrl: 'https://flagcdn.com/w20/re.png' },
  { id: 190, name: 'Romênia', flagUrl: 'https://flagcdn.com/w20/ro.png' },
  { id: 191, name: 'Ruanda', flagUrl: 'https://flagcdn.com/w20/rw.png' },
  { id: 192, name: 'Rússia', flagUrl: 'https://flagcdn.com/w20/ru.png' },
  { id: 193, name: 'Saara Ocidental', flagUrl: 'https://flagcdn.com/w20/eh.png' },
  { id: 194, name: 'Samoa', flagUrl: 'https://flagcdn.com/w20/ws.png' },
  { id: 195, name: 'Samoa Americana', flagUrl: 'https://flagcdn.com/w20/as.png' },
  { id: 196, name: 'San Marino', flagUrl: 'https://flagcdn.com/w20/sm.png' },
  { id: 197, name: 'Santa Helena', flagUrl: 'https://flagcdn.com/w20/sh.png' },
  { id: 198, name: 'Santa Lúcia', flagUrl: 'https://flagcdn.com/w20/lc.png' },
  { id: 199, name: 'Seicheles', flagUrl: 'https://flagcdn.com/w20/sc.png' },
  { id: 200, name: 'Senegal', flagUrl: 'https://flagcdn.com/w20/sn.png' },
  { id: 201, name: 'Serra Leoa', flagUrl: 'https://flagcdn.com/w20/sl.png' },
  { id: 202, name: 'Singapura', flagUrl: 'https://flagcdn.com/w20/sg.png' },
  { id: 203, name: 'Sint Maarten', flagUrl: 'https://flagcdn.com/w20/sx.png' },
  { id: 204, name: 'Somália', flagUrl: 'https://flagcdn.com/w20/so.png' },
  { id: 205, name: 'Sri Lanka', flagUrl: 'https://flagcdn.com/w20/lk.png' },
  { id: 206, name: 'Sudão', flagUrl: 'https://flagcdn.com/w20/sd.png' },
  { id: 207, name: 'Sudão do Sul', flagUrl: 'https://flagcdn.com/w20/ss.png' },
  { id: 208, name: 'Suriname', flagUrl: 'https://flagcdn.com/w20/sr.png' },
  { id: 209, name: 'Suécia', flagUrl: 'https://flagcdn.com/w20/se.png' },
  { id: 210, name: 'Suíça', flagUrl: 'https://flagcdn.com/w20/ch.png' },
  { id: 211, name: 'Svalbard e Jan Mayen', flagUrl: 'https://flagcdn.com/w20/sj.png' },
  { id: 212, name: 'São Bartolomeu', flagUrl: 'https://flagcdn.com/w20/bl.png' },
  { id: 213, name: 'São Cristóvão e Névis', flagUrl: 'https://flagcdn.com/w20/kn.png' },
  { id: 214, name: 'São Martinho', flagUrl: 'https://flagcdn.com/w20/mf.png' },
  { id: 215, name: 'São Pedro e Miquelão', flagUrl: 'https://flagcdn.com/w20/pm.png' },
  { id: 216, name: 'São Tomé e Príncipe', flagUrl: 'https://flagcdn.com/w20/st.png' },
  { id: 217, name: 'São Vicente e Granadinas', flagUrl: 'https://flagcdn.com/w20/vc.png' },
  { id: 218, name: 'Sérvia', flagUrl: 'https://flagcdn.com/w20/rs.png' },
  { id: 219, name: 'Síria', flagUrl: 'https://flagcdn.com/w20/sy.png' },
  { id: 220, name: 'Tadjiquistão', flagUrl: 'https://flagcdn.com/w20/tj.png' },
  { id: 221, name: 'Tailândia', flagUrl: 'https://flagcdn.com/w20/th.png' },
  { id: 222, name: 'Taiwan', flagUrl: 'https://flagcdn.com/w20/tw.png' },
  { id: 223, name: 'Tanzânia', flagUrl: 'https://flagcdn.com/w20/tz.png' },
  { id: 224, name: 'Tchéquia', flagUrl: 'https://flagcdn.com/w20/cz.png' },
  { id: 225, name: 'Território Britânico do Oceano Índico', flagUrl: 'https://flagcdn.com/w20/io.png' },
  { id: 226, name: 'Territórios Franceses do Sul', flagUrl: 'https://flagcdn.com/w20/tf.png' },
  { id: 227, name: 'Territórios palestinos', flagUrl: 'https://flagcdn.com/w20/ps.png' },
  { id: 228, name: 'Timor-Leste', flagUrl: 'https://flagcdn.com/w20/tl.png' },
  { id: 229, name: 'Togo', flagUrl: 'https://flagcdn.com/w20/tg.png' },
  { id: 230, name: 'Tokelau', flagUrl: 'https://flagcdn.com/w20/tk.png' },
  { id: 231, name: 'Tonga', flagUrl: 'https://flagcdn.com/w20/to.png' },
  { id: 232, name: 'Trinidad e Tobago', flagUrl: 'https://flagcdn.com/w20/tt.png' },
  { id: 233, name: 'Tunísia', flagUrl: 'https://flagcdn.com/w20/tn.png' },
  { id: 234, name: 'Turcomenistão', flagUrl: 'https://flagcdn.com/w20/tm.png' },
  { id: 235, name: 'Turquia', flagUrl: 'https://flagcdn.com/w20/tr.png' },
  { id: 236, name: 'Tuvalu', flagUrl: 'https://flagcdn.com/w20/tv.png' },
  { id: 237, name: 'Ucrânia', flagUrl: 'https://flagcdn.com/w20/ua.png' },
  { id: 238, name: 'Uganda', flagUrl: 'https://flagcdn.com/w20/ug.png' },
  { id: 239, name: 'Uruguai', flagUrl: 'https://flagcdn.com/w20/uy.png' },
  { id: 240, name: 'Uzbequistão', flagUrl: 'https://flagcdn.com/w20/uz.png' },
  { id: 241, name: 'Vanuatu', flagUrl: 'https://flagcdn.com/w20/vu.png' },
  { id: 242, name: 'Venezuela', flagUrl: 'https://flagcdn.com/w20/ve.png' },
  { id: 243, name: 'Vietnã', flagUrl: 'https://flagcdn.com/w20/vn.png' },
  { id: 244, name: 'Wallis e Futuna', flagUrl: 'https://flagcdn.com/w20/wf.png' },
  { id: 245, name: 'Zimbábue', flagUrl: 'https://flagcdn.com/w20/zw.png' },
  { id: 246, name: 'Zâmbia', flagUrl: 'https://flagcdn.com/w20/zm.png' },
  { id: 247, name: 'África do Sul', flagUrl: 'https://flagcdn.com/w20/za.png' },
  { id: 248, name: 'Áustria', flagUrl: 'https://flagcdn.com/w20/at.png' },
  { id: 249, name: 'Índia', flagUrl: 'https://flagcdn.com/w20/in.png' },];

  selectedCountry: { id: number; name: string; flagUrl: string } | null = null;

  onCountrySelected(country: { id: number; name: string; flagUrl: string }) {
    this.selectedCountry = country;
  }

  preventNegative(event: KeyboardEvent): void {
    if (event.key === '-' || event.key === '+' || event.key === 'e') {
      event.preventDefault();
    }
  }
bercosDisponiveis: any[] = [];

  ngOnInit(): void {
    this._bercoService.getBercosListSemPaginacao().subscribe({
      next: (res) => {
        this.bercosDisponiveis = Array.isArray(res) ? res : [];
      },
      error: () => {
        this.bercosDisponiveis = [];
      }
    });
    if (this.data) {
      this.empForm.patchValue(this.data.empForm);
    }
  }

  onFileSelected(event: Event): void {
    const input = event.target as HTMLInputElement;
    if (input.files && input.files.length > 0) {
      const file = input.files[0];
      const allowedTypes = ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];

      if (!allowedTypes.includes(file.type)) {
        this.toastService.error('Apenas arquivos PDF ou Word são permitidos.');
        return;
      }

      this.selectedFile = file;
      this.fileName = file.name;
      const reader = new FileReader();
      reader.onload = (e) => {
        this.imageUrl = (e.target?.result as string) || '';
      };
      reader.readAsDataURL(file);
    }}

  getErrorMessage(formControlName: string): string {
    if (this.empForm.get(formControlName)?.hasError('required')) {
      return 'Campo obrigatório';
    }
    if (this.empForm.get(formControlName)?.hasError('email')) {
      return 'E-mail inválido';
    }
    return '';
  }

  removeImage() {
    this.imageUrl = null;
    this.fileName = '';
  }

  onFormSubmit() {
    console.log(JSON.stringify(this.empForm.value));
    if (this.empForm.valid) {

      if (this.selectedFile) {
        this._empService.addEmployee1(this.empForm.value, this.selectedFile).subscribe({
          next: () => {
            this._dialogRef.close(true);
            this.toastService.success('Navio cadastrado com sucesso!');
          },
          error: (err: any) => {
            console.error(err);
          },
        });
      } else {
        console.error('Nenhum arquivo selecionado');
      }
    }
  }
}
