import { ChangeDetectorRef, Component, ViewChild } from '@angular/core';
import { NavioEditComponent } from '../crud-navios/navio-edit/navio-edit.component';
import { MatPaginator, MatPaginatorModule, PageEvent } from '@angular/material/paginator';
import { MatTableDataSource, MatTableModule } from '@angular/material/table';
import { MatSort, MatSortModule } from '@angular/material/sort';
import { MatDialog } from '@angular/material/dialog';
import { NavioService } from '../../services/navio.service';
import { JwtDecoderService } from '../../jwt-decoder.service';
import { AuthService } from '../../auth.service';
import { CoreService } from '../../core/core.service';
import { ToastrService } from 'ngx-toastr';
import { jwtDecode } from 'jwt-decode';
import { MatIcon, MatIconModule } from '@angular/material/icon';
import { MatToolbarModule } from '@angular/material/toolbar';
import { CommonModule, NumberFormatStyle } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatSelectModule } from '@angular/material/select';
import { MatRadioModule } from '@angular/material/radio';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { AddSearchComponent } from '../../shared/addAndSearch/add-search/add-search.component';
import { DIR_DOCUMENT } from '@angular/cdk/bidi';
import { UserService } from '../../services/users/user.service';
interface UsuarioData {
  id: number;
  imo: number;
  mmsi: number;
  nome: string;
  loa: number;
  boca: number;
  dwt: number;
  pontal: number;
  ponte_mfold: number;
  mfold_quilha: number;
  categoria: number;
  flag: string;
  obs: string;
  action: number;
}
@Component({
  selector: 'app-user',
  standalone: true,
  imports: [
    MatPaginatorModule,
    MatToolbarModule,
    MatTableModule,
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatInputModule,
    MatFormFieldModule,
    MatDatepickerModule,
    MatSelectModule,
    MatRadioModule,
    MatIconModule,
    MatSnackBarModule,
    MatSortModule,
    AddSearchComponent,
  ],
  templateUrl: './user.component.html',
  styleUrl: './user.component.scss'
})
export class UserComponent {
  user: any;
  authTokenPresent = false;
  totalItems = 100;
  pageSize = 10;
  currentPage = 1;

  displayedColumns: string[] = ['id', 'email', 'role', 'sendEmail'];
  dataSource = new MatTableDataSource<UsuarioData>();

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    private _dialog: MatDialog,
    private _userService: UserService,
    private jwtDecoderService: JwtDecoderService,
    private authService: AuthService,
    private _coreService: CoreService,
    private cdr: ChangeDetectorRef,
    private toastService: ToastrService,


  ) { }
  ngOnInit(): void {
    this.validationToken();
  }
  parseUserString(userString: string) {
    const userRegex = /User\(id=(\d+), email=([^)]+)\)/;
    const match = userRegex.exec(userString);
    if (match) {
      return {
        id: parseInt(match[1], 10),
        email: match[2],
      };
    }
    return null;
  }
  ngAfterViewInit(): void {
    this.loadData();
  }

  validationToken() {
    this.authService.authToken$.subscribe((isLoggedIn) => {
      this.authTokenPresent = isLoggedIn;
      if (this.authTokenPresent) {
        const token = sessionStorage.getItem('accessToken')!;
        this.user = jwtDecode(token);
        const isExpired =
          this.user && this.user.exp
            ? this.user.exp < Date.now() / 1000
            : false;
        if (isExpired) {
          sessionStorage.removeItem('accessToken');
        }
        this.user = this.jwtDecoderService.decodeToken(token);
        console.log(this.user);
      }
      this.cdr.detectChanges();
    });
  }

  loadData(event?: PageEvent): void {
    const pageIndex = event ? event.pageIndex + 1 : this.currentPage - 1;

    // Verifica se há dados no sessionStorage
    if (typeof sessionStorage !== 'undefined') {
      const storedData = sessionStorage.getItem('naviosSearch');
      if (storedData) {
        const navios = JSON.parse(storedData); // Converte o JSON em um objeto
        console.log('Dados recuperados do sessionStorage:', navios);

        // Atualiza os dados na tabela
        this.dataSource.data = navios;

        // Atualiza o total de itens para paginação (opcional)
        this.totalItems = navios.length;

        // Configurações do paginator e sort
        if (this.paginator && this.sort) {
          this.dataSource.paginator = this.paginator;
          this.dataSource.sort = this.sort;
        }

        // Remove dados do sessionStorage após o uso
        sessionStorage.removeItem('naviosSearch');
        console.log('naviosSearch removido do sessionStorage.');

        return; // Retorna para evitar chamada à API
      } else {
        console.warn('Nenhum dado encontrado no sessionStorage.');
      }
    }

    // Caso os dados não estejam no sessionStorage, chama a API
    this._userService.getUserList(pageIndex, this.pageSize).subscribe({
      next: (res: any) => {
        const navios = res._embedded.userResponseList;
        console.log(navios);
        console.log(navios)
        this.dataSource.data = navios.filter((navio: any) => navio.role === 'COMPANY');
        console.log(this.dataSource.data)
        this.totalItems = res.page.totalElements;
        console.log(res.page.totalElements);
      },
      error: (err: any) => {
        console.error(err);
        if (err.error.title) {
          this._coreService.openSnackBar(err.error.title);
        } else {
          this._coreService.openSnackBar(err.error.message);
        }
      },
    });
  }

  applyFilter(event: Event) {
    const filterValue = (event.target as HTMLInputElement).value;
    this.dataSource.filter = filterValue.trim().toLowerCase();

    if (this.dataSource.paginator) {
      this.dataSource.paginator.firstPage();
    }
  }

 
  



  openEditForm(data: any) {
    this._dialog.open(NavioEditComponent, {
      data, // Passa os dados para o componente de edição
      autoFocus: true, // Foca no primeiro campo interativo do formulário
      disableClose: true, // Impede que o diálogo feche ao clicar fora
      width: '600px', // Define a largura do diálogo
    });
    this.cdr.detectChanges();

  }
  

  toggleEmail(row: any): void {
    const newSendEmailStatus = !row.sendEmail; // Define o novo estado que será enviado para a API
    this._userService.sendEmail(row.id, newSendEmailStatus).subscribe({
      next: () => {
        row.sendEmail = newSendEmailStatus; // Atualiza o estado localmente apenas após o sucesso da requisição
        this.toastService.success('Status de envio de email atualizado com sucesso!');
      },
      error: () => {
        this.toastService.error('Erro ao atualizar status de envio de email.');
      }
    });
  }




}
