import { HttpClient, HttpErrorResponse, HttpParams } from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, tap } from 'rxjs/operators';
import { AsyncValidatorFn, AbstractControl, ValidationErrors, Validators } from '@angular/forms';
import { map } from 'rxjs/operators';
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/.env'; // Importa o environment

@Injectable({
  providedIn: 'root'
})
export class BlackListService {
  users: any[] = [];

  private apiUrl = environment.API_URL + '/api/black-list';
  private apiUrl_verifica_imo = environment.API_URL + '/api/vdatas';

  constructor(private _http: HttpClient) {}

  addEmployee(data: any): Observable<any> {
    return this._http.post(this.apiUrl, data).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      }));
  }

  updateEmployee(id: number, data: any): Observable<any> {
    return this._http.put(`${this.apiUrl}/${id}`, data).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      }));
  }

  getEmployeeList(pageIndex: number, pageSize: number): Observable<any> {
    let params = new HttpParams()
      .set('page', pageIndex.toString())
      .set('size', pageSize.toString())
      .set('sort', 'id,desc');

    return this._http.get<any>(this.apiUrl, { params }).pipe(
      tap((res: any) => {
        this.users = res;
        console.log(this.users)
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  getEmployeeListbyId(id: number): Observable<any> {
    return this._http.get(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  getEmployeebyIMO(imo: number): Observable<any> {
    return this._http.get(`${this.apiUrl_verifica_imo}/${imo}`).pipe(
      tap((res: any) => {
        console.log(res)
        this.users = res;
      }),
      catchError(error => {
        console.log(error)
        return throwError(error);
      })
    );
  }

  deleteEmployee(id: number): Observable<any> {
    return this._http.delete(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      }));
  }
  getAllBlackListSemPaginacao(): Observable<any[]> {
  return this._http.get<any>(`${this.apiUrl}/sem-paginacao`).pipe(
    map((res: any) => res._embedded?.blackListResponseList || [])
  );
}
}
