import { Component, Input } from '@angular/core';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-add-search',
  standalone: true,
  imports: [MatButtonModule],
  templateUrl: './add-search.component.html',
  styleUrl: './add-search.component.scss'
})
export class AddSearchComponent {
  @Input() title: string = 'Default Title';
  @Input() primaryButtonText: string = 'Primary Action';
  @Input() primaryButtonColor: string = 'primary';
  @Input() primaryButtonAction: () => void = () => {};

  @Input() secondaryButtonText: string = 'Secondary Action';
  @Input() secondaryButtonColor: string = 'accent';
  @Input() secondaryButtonAction: () => void = () => {};

  onPrimaryButtonClick() {
    if (this.primaryButtonAction) {
      this.primaryButtonAction();
    }
  }

  onSecondaryButtonClick() {
    if (this.secondaryButtonAction) {
      this.secondaryButtonAction();
    }
  }
}
