import { Component, HostListener, OnInit } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MatGridListModule } from '@angular/material/grid-list';
import { MatCardModule } from '@angular/material/card';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import { MatMenuModule } from '@angular/material/menu';
import { ChartModule } from 'primeng/chart';
import { HttpClientModule } from '@angular/common/http'; // Import necessário para requisições HTTP
import { NavioSearchComponent } from '../crud-navios/navio-search/navio-search.component';
import { NavioService } from '../../services/navio.service';
import { CsvService } from '../../csv.service';
@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  standalone: true,
  imports: [
    CommonModule,
    MatGridListModule,
    MatCardModule,
    MatButtonModule,
    MatIconModule,
    MatMenuModule,
    ChartModule,
    HttpClientModule, // Adicionado para suporte HTTP
    NavioSearchComponent // Incluído se for usado no template
  ],
  providers: [NavioService] // Providenciado o serviço
})
export class DashboardComponent implements OnInit {
  data: any;
  dataBar: any;
  dataDoughnut: any;
  options: any;
  totalNavios: number = 0;
  totalUsuarios: number = 0;
  totalBercos: number = 0;
  totalAceites: number = 0;
  isSmallScreen = false;

  @HostListener('window:resize', ['$event'])
  onResize() {
    this.isSmallScreen = window.innerWidth < 768;
  }
  constructor(private navioService: NavioService,
              private _csvService: CsvService // Injetando o serviço CSV
  ) {}

  ngOnInit(): void {
    // Consumindo o serviço para obter os dados do dashboard
    this.navioService.getDadosDah().subscribe(response => {
      // Populando os cards com os valores do JSON
      this.totalNavios = response.totalVessels;
      this.totalUsuarios = response.totalUsers;
      this.totalBercos = response.totalBercos;
      this.totalAceites = response.totalAccepts;

      // Configuração dos gráficos
      this.data = {
        labels: ['Não Aceitos', 'Aceitos'],
        datasets: [
          {
            data: [response.statusCounts.NE, response.statusCounts.Y],
            backgroundColor: ['#FF6384', '#36A2EB']
          }
        ]
      };

      this.dataBar = {
        labels: ['Aceitos', 'Não Aceitos', 'Não Especificados'],
        datasets: [
          {
            label: 'Processos',
            data: [response.statusCounts.Y, response.statusCounts.NE, response.statusCounts.N],
            backgroundColor: ['#4BC0C0', '#FF6384', '#FFCE56']
          }
        ]
      };

      this.dataDoughnut = {
        labels: ['Aceitos', 'Não Aceitos', 'Blacklist'],
        datasets: [
          {
            data: [response.statusCounts.Y, response.statusCounts.NE, response.totalBlackLists],
            backgroundColor: ['#36A2EB', '#FF6384', '#FFCE56']
          }
        ]
      };

      // Configuração padrão para os gráficos
      this.options = {
        responsive: true,
        maintainAspectRatio: false
      };
    });
  }

  public saveDataInCSV(name: string): void {
    // organize o data com base na response e deixe nesse formato {"titulo": "valor"}
    const data: Array<any> = [
  { "Indicador": "Total de Navios", "Valor": this.totalNavios },
  { "Indicador": "Total de Usuários", "Valor": this.totalUsuarios },
  { "Indicador": "Total de Berços", "Valor": this.totalBercos },
  { "Indicador": "Total de Aceites", "Valor": this.totalAceites },
  { "Indicador": "Total Aceitos", "Valor": this.dataDoughnut?.datasets[0]?.data[0] ?? 0 },
  { "Indicador": "Total Não Aceitos", "Valor": this.dataDoughnut?.datasets[0]?.data[1] ?? 0 },
  { "Indicador": "Total Não Especificados", "Valor": this.dataBar?.datasets[0]?.data[2] ?? 0 },
  { "Indicador": "Navios na Black-list", "Valor": this.dataDoughnut?.datasets[0]?.data[2] ?? 0 }
];

    console.log(data);
    let csvContent = this._csvService.saveDataInCSV(data);

    var hiddenElement = document.createElement('a');
    hiddenElement.href = 'data:text/csv;charset=utf-8,' + encodeURI(csvContent);
    hiddenElement.target = '_blank';
    hiddenElement.download = name + '.csv';
    hiddenElement.click();
  }
}
