import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatSelectModule } from '@angular/material/select';
import { MatRadioModule } from '@angular/material/radio';
import { MatIconModule } from '@angular/material/icon';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatDialogModule } from '@angular/material/dialog';
import { ToastrService } from 'ngx-toastr';
import { BercosComponent } from '../bercos/bercos.component';
import { BercosService } from '../../../services/bercos/bercos.service';

@Component({
  selector: 'app-berco-edit',
  standalone: true,
  imports: [
    MatDialogModule,
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatInputModule,
    MatFormFieldModule,
    MatDatepickerModule,
    MatSelectModule,
    MatRadioModule,
    MatIconModule, 
    MatSnackBarModule,
    BercosComponent,
  ],
    templateUrl: './berco-edit.component.html',
  styleUrl: './berco-edit.component.scss'
})
export class BercoEditComponent implements OnInit {
  bercoForm: FormGroup;

  constructor(
    private _fb: FormBuilder,
    private _bercoService: BercosService,
    private _dialogRef: MatDialogRef<BercoEditComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private toastService: ToastrService,
  ) {
    this.bercoForm = this._fb.group({
      nome: ['', Validators.required],
      compri_estrutural: ['', Validators.required],
      compri_util: ['', Validators.required],
      dwt: ['', Validators.required],
      largura: ['', Validators.required],
      profundidade: ['', Validators.required],
      calado_max: ['', Validators.required],
      boca_max: ['', Validators.required],
      loa_max: ['', Validators.required],
      categoria:['', Validators.required]

    });
  }
  categoria = [
    { id: 1, nome: 'Granel Sólido' },
    { id: 2, nome: 'Granel Líquido' },
    { id: 3, nome: 'Carga Geral' }
  ];
  preventNegative(event: KeyboardEvent): void {
    if (event.key === '-' || event.key === '+' || event.key === 'e') {
      event.preventDefault();
    }
  }

  ngOnInit(): void {
    if (this.data) {
      console.log(this.data)
      this.bercoForm.patchValue(this.data);
    }
  }

  getErrorMessage(formControlName: string): string {
    if (this.bercoForm.get(formControlName)?.hasError('required')) {
      return 'Campo obrigatório';
    }
    return '';
  }

  onFormSubmit() {
    if (this.bercoForm.valid) {
      if (this.data) {
        this._bercoService.updateEmployee(this.data.id, this.bercoForm.value).subscribe({
          next: (val: any) => {
            this.toastService.success('Detalhes do berço atualizados!');
            this._dialogRef.close(true);
          },
          error: (err: any) => {
            console.error(err);
          },
        });
      }
    }
  }
}