import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot, UrlTree } from '@angular/router';
import { Observable } from 'rxjs';
import { JwtDecoderService } from './jwt-decoder.service';
import { ChangeDetectorRef } from '@angular/core';
import { Location } from '@angular/common';

@Injectable({
  providedIn: 'root'
})
export class LoginSignupService {
  private decodedToken: any;

  constructor(
    private jwtDecoderService: JwtDecoderService,
    private location: Location
  ) {}

  canActivate(
    state: RouterStateSnapshot): Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree {
    
    const authTokenPresent = sessionStorage.getItem('accessToken');

    return authTokenPresent ? this.validToken(authTokenPresent) : true;
    
  }
  validToken(authTokenPresent:string){
    this.decodedToken = this.jwtDecoderService.decodeToken(authTokenPresent);
    return this.decodedToken ? false : true ;
  }
}
