import { Component, Inject, OnInit } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { CommonModule } from '@angular/common';
import { MatButtonModule } from '@angular/material/button';
import { MatCardModule } from '@angular/material/card';
import { MatTabsModule } from '@angular/material/tabs';
import { MatDialogModule } from '@angular/material/dialog';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../../../environments/.env';
@Component({
  selector: 'app-visualizacao-aceite',
  standalone: true,
  imports: [
    CommonModule,
    MatButtonModule,
    MatCardModule,
    MatTabsModule,
    MatDialogModule,
  ],

  templateUrl: './visualizacao-aceite.component.html',
  styleUrls: ['./visualizacao-aceite.component.scss'],
})
export class VisualizacaoAceiteComponent implements OnInit {
  constructor(@Inject(MAT_DIALOG_DATA) public data: any,
  private httpClient: HttpClient ,// Adicione isto
) {}

  ngOnInit(): void {
    console.log(this.data);
  }

  parseUserString(userString: string) {
    const userRegex = /User\(id=(\d+), email=([^)]+)\)/;
    const match = userRegex.exec(userString);
    if (match) {
      return {
        id: parseInt(match[1], 10),
        email: match[2],
      };
    }
    return null;
  }

  downloadNavioFunction() {
    this.httpClient
      .get(`${environment.API_URL}/api/download-file`, {
        params: { filename: this.data.path },
        responseType: 'blob', // Adiciona 'blob' para lidar com arquivos binários
      })
      .subscribe({
        next: (response) => {
          // Criação de um URL temporário para o arquivo
          const blob = new Blob([response]);
          const link = document.createElement('a');
          link.href = window.URL.createObjectURL(blob);
          link.download = this.data.path || 'download'; // Define o nome do arquivo
          link.click();

          // Libera o objeto URL após o download
          window.URL.revokeObjectURL(link.href);
          console.log('Download iniciado:', this.data.path);
        },
        error: (error) => {
          console.error('Erro ao baixar o arquivo:', error);
        },
      });
  }}
