import { AsyncValidator, AbstractControl, ValidationErrors, Validators } from '@angular/forms';
import { Observable, of } from 'rxjs';
import { map, catchError } from 'rxjs/operators';
import { AceiteService } from '../services/aceites/aceite.service';
import { Injectable } from '@angular/core';

@Injectable({ providedIn: 'root' })

export class Validator implements AsyncValidator {

  constructor(private companyService: AceiteService) { }

  validate(
    val: AbstractControl
  ): Promise<ValidationErrors | null> | Observable<ValidationErrors | null> {
    return this.companyService.getAceiteListbyId(val.value).pipe(
      map(isTaken => (isTaken ? { uniqueCompanyName: true } : null)),
      catchError(() => of(null))
    );
  }
}