import { ChangeDetectorRef, Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { NavioService } from '../../../services/navio.service';
import { CoreService } from '../../../core/core.service';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatSelectModule } from '@angular/material/select';
import { MatRadioModule } from '@angular/material/radio';
import { MatIconModule } from '@angular/material/icon'; // Corrigido
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatDialogModule } from '@angular/material/dialog';
import { NaviosComponent } from '../navios/navios.component';
import { ToastrService } from 'ngx-toastr';
import { NgxCurrencyDirective } from 'ngx-currency';

@Component({
  selector: 'app-navio-search',
  standalone: true,
  imports: [
    MatDialogModule,
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatInputModule,
    MatFormFieldModule,
    MatDatepickerModule,
    MatSelectModule,
    MatRadioModule,
    MatIconModule,
    MatSnackBarModule,
    NaviosComponent,
    NgxCurrencyDirective,
  ],
  templateUrl: './navio-search.component.html',
  styleUrl: './navio-search.component.scss',
})
export class NavioSearchComponent implements OnInit {
  fileName = '';
  imageUrl: string | ArrayBuffer | null = '';
  empForm: FormGroup;
  selectedFile: File | null = null;

  categoria: number[] = [1, 2, 3];

  constructor(
    private _fb: FormBuilder,
    private _empService: NavioService,
    private _dialogRef: MatDialogRef<NavioSearchComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any,
    private toastService: ToastrService,
    private cdr: ChangeDetectorRef,

  ) {
    this.empForm = this._fb.group({
      imo: [''],
      dataInicio: [''],
      dataFim: [''],
    });
  }
  countries = [
    { id: 1, name: 'Afeganistão', flagUrl: 'https://flagcdn.com/w20/af.png' },
    { id: 2, name: 'África do Sul', flagUrl: 'https://flagcdn.com/w20/za.png' },
    { id: 3, name: 'Albânia', flagUrl: 'https://flagcdn.com/w20/al.png' },
    { id: 4, name: 'Alemanha', flagUrl: 'https://flagcdn.com/w20/de.png' },
    { id: 5, name: 'Andorra', flagUrl: 'https://flagcdn.com/w20/ad.png' },
    { id: 6, name: 'Angola', flagUrl: 'https://flagcdn.com/w20/ao.png' },
    {
      id: 7,
      name: 'Antígua e Barbuda',
      flagUrl: 'https://flagcdn.com/w20/ag.png',
    },
    {
      id: 8,
      name: 'Arábia Saudita',
      flagUrl: 'https://flagcdn.com/w20/sa.png',
    },
    { id: 9, name: 'Argélia', flagUrl: 'https://flagcdn.com/w20/dz.png' },
    { id: 10, name: 'Argentina', flagUrl: 'https://flagcdn.com/w20/ar.png' },
    { id: 11, name: 'Armênia', flagUrl: 'https://flagcdn.com/w20/am.png' },
    { id: 12, name: 'Austrália', flagUrl: 'https://flagcdn.com/w20/au.png' },
    { id: 13, name: 'Áustria', flagUrl: 'https://flagcdn.com/w20/at.png' },
    { id: 14, name: 'Azerbaijão', flagUrl: 'https://flagcdn.com/w20/az.png' },
    { id: 15, name: 'Bahamas', flagUrl: 'https://flagcdn.com/w20/bs.png' },
    { id: 16, name: 'Bahrein', flagUrl: 'https://flagcdn.com/w20/bh.png' },
    { id: 17, name: 'Bangladesh', flagUrl: 'https://flagcdn.com/w20/bd.png' },
    { id: 18, name: 'Barbados', flagUrl: 'https://flagcdn.com/w20/bb.png' },
    { id: 19, name: 'Bélgica', flagUrl: 'https://flagcdn.com/w20/be.png' },
    { id: 20, name: 'Belize', flagUrl: 'https://flagcdn.com/w20/bz.png' },
    { id: 21, name: 'Benin', flagUrl: 'https://flagcdn.com/w20/bj.png' },
    { id: 22, name: 'Bielorrússia', flagUrl: 'https://flagcdn.com/w20/by.png' },
    { id: 23, name: 'Bolívia', flagUrl: 'https://flagcdn.com/w20/bo.png' },
    {
      id: 24,
      name: 'Bósnia e Herzegovina',
      flagUrl: 'https://flagcdn.com/w20/ba.png',
    },
    { id: 25, name: 'Botswana', flagUrl: 'https://flagcdn.com/w20/bw.png' },
    { id: 26, name: 'Brasil', flagUrl: 'https://flagcdn.com/w20/br.png' },
    { id: 27, name: 'Brunei', flagUrl: 'https://flagcdn.com/w20/bn.png' },
    { id: 28, name: 'Bulgária', flagUrl: 'https://flagcdn.com/w20/bg.png' },
    { id: 29, name: 'Burkina Faso', flagUrl: 'https://flagcdn.com/w20/bf.png' },
    { id: 30, name: 'Burundi', flagUrl: 'https://flagcdn.com/w20/bi.png' },
    { id: 31, name: 'Butão', flagUrl: 'https://flagcdn.com/w20/bt.png' },
    { id: 32, name: 'Cabo Verde', flagUrl: 'https://flagcdn.com/w20/cv.png' },
    { id: 33, name: 'Camboja', flagUrl: 'https://flagcdn.com/w20/kh.png' },
    { id: 34, name: 'Camarões', flagUrl: 'https://flagcdn.com/w20/cm.png' },
    { id: 35, name: 'Canadá', flagUrl: 'https://flagcdn.com/w20/ca.png' },
    { id: 36, name: 'Catar', flagUrl: 'https://flagcdn.com/w20/qa.png' },
    { id: 37, name: 'Cazaquistão', flagUrl: 'https://flagcdn.com/w20/kz.png' },
    { id: 38, name: 'Chade', flagUrl: 'https://flagcdn.com/w20/td.png' },
    { id: 39, name: 'Chile', flagUrl: 'https://flagcdn.com/w20/cl.png' },
    { id: 40, name: 'China', flagUrl: 'https://flagcdn.com/w20/cn.png' },
    { id: 41, name: 'Chipre', flagUrl: 'https://flagcdn.com/w20/cy.png' },
    { id: 42, name: 'Colômbia', flagUrl: 'https://flagcdn.com/w20/co.png' },
    { id: 43, name: 'Comores', flagUrl: 'https://flagcdn.com/w20/km.png' },
    { id: 44, name: 'Congo', flagUrl: 'https://flagcdn.com/w20/cg.png' },
    {
      id: 45,
      name: 'Costa do Marfim',
      flagUrl: 'https://flagcdn.com/w20/ci.png',
    },
    { id: 46, name: 'Costa Rica', flagUrl: 'https://flagcdn.com/w20/cr.png' },
    { id: 47, name: 'Croácia', flagUrl: 'https://flagcdn.com/w20/hr.png' },
    { id: 48, name: 'Cuba', flagUrl: 'https://flagcdn.com/w20/cu.png' },
    { id: 49, name: 'Dinamarca', flagUrl: 'https://flagcdn.com/w20/dk.png' },
    { id: 50, name: 'Dominica', flagUrl: 'https://flagcdn.com/w20/dm.png' },
    { id: 51, name: 'Egito', flagUrl: 'https://flagcdn.com/w20/eg.png' },
    { id: 52, name: 'El Salvador', flagUrl: 'https://flagcdn.com/w20/sv.png' },
    {
      id: 53,
      name: 'Emirados Árabes Unidos',
      flagUrl: 'https://flagcdn.com/w20/ae.png',
    },
    { id: 54, name: 'Equador', flagUrl: 'https://flagcdn.com/w20/ec.png' },
    { id: 55, name: 'Eritreia', flagUrl: 'https://flagcdn.com/w20/er.png' },
    { id: 56, name: 'Eslováquia', flagUrl: 'https://flagcdn.com/w20/sk.png' },
    { id: 57, name: 'Eslovênia', flagUrl: 'https://flagcdn.com/w20/si.png' },
    { id: 58, name: 'Espanha', flagUrl: 'https://flagcdn.com/w20/es.png' },
    {
      id: 59,
      name: 'Estados Unidos',
      flagUrl: 'https://flagcdn.com/w20/us.png',
    },
    { id: 60, name: 'Estônia', flagUrl: 'https://flagcdn.com/w20/ee.png' },
    { id: 61, name: 'Eswatini', flagUrl: 'https://flagcdn.com/w20/sz.png' },
    { id: 62, name: 'Etiópia', flagUrl: 'https://flagcdn.com/w20/et.png' },
    { id: 63, name: 'Fiji', flagUrl: 'https://flagcdn.com/w20/fj.png' },
    { id: 64, name: 'Filipinas', flagUrl: 'https://flagcdn.com/w20/ph.png' },
    { id: 65, name: 'Finlândia', flagUrl: 'https://flagcdn.com/w20/fi.png' },
    { id: 66, name: 'França', flagUrl: 'https://flagcdn.com/w20/fr.png' },
    { id: 67, name: 'Guatemala', flagUrl: 'https://flagcdn.com/w20/gt.png' },
    { id: 68, name: 'Guiana', flagUrl: 'https://flagcdn.com/w20/gf.png' },
    { id: 69, name: 'Guiné', flagUrl: 'https://flagcdn.com/w20/gn.png' },
    { id: 70, name: 'Guiné-Bissau', flagUrl: 'https://flagcdn.com/w20/gw.png' },
    { id: 71, name: 'Haiti', flagUrl: 'https://flagcdn.com/w20/ht.png' },
    { id: 72, name: 'Honduras', flagUrl: 'https://flagcdn.com/w20/hn.png' },
    { id: 73, name: 'Hungria', flagUrl: 'https://flagcdn.com/w20/hu.png' },
    { id: 74, name: 'Iêmen', flagUrl: 'https://flagcdn.com/w20/ye.png' },
    {
      id: 75,
      name: 'Ilhas Marshall',
      flagUrl: 'https://flagcdn.com/w20/mh.png',
    },
    {
      id: 76,
      name: 'Ilhas Salomão',
      flagUrl: 'https://flagcdn.com/w20/sb.png',
    },
    { id: 77, name: 'Índia', flagUrl: 'https://flagcdn.com/w20/in.png' },
    { id: 78, name: 'Indonésia', flagUrl: 'https://flagcdn.com/w20/id.png' },
    { id: 79, name: 'Irã', flagUrl: 'https://flagcdn.com/w20/ir.png' },
    { id: 80, name: 'Iraque', flagUrl: 'https://flagcdn.com/w20/iq.png' },
    { id: 81, name: 'Irlanda', flagUrl: 'https://flagcdn.com/w20/ie.png' },
    { id: 82, name: 'Islândia', flagUrl: 'https://flagcdn.com/w20/is.png' },
    { id: 83, name: 'Israel', flagUrl: 'https://flagcdn.com/w20/il.png' },
    { id: 84, name: 'Itália', flagUrl: 'https://flagcdn.com/w20/it.png' },
    { id: 85, name: 'Jamaica', flagUrl: 'https://flagcdn.com/w20/jm.png' },
    { id: 86, name: 'Japão', flagUrl: 'https://flagcdn.com/w20/jp.png' },
    { id: 87, name: 'Jordânia', flagUrl: 'https://flagcdn.com/w20/jo.png' },
    { id: 88, name: 'Kosovo', flagUrl: 'https://flagcdn.com/w20/xk.png' },
    { id: 89, name: 'Kuwait', flagUrl: 'https://flagcdn.com/w20/kw.png' },
    { id: 90, name: 'Quirguistão', flagUrl: 'https://flagcdn.com/w20/kg.png' },
    { id: 91, name: 'Laos', flagUrl: 'https://flagcdn.com/w20/la.png' },
    { id: 92, name: 'Letônia', flagUrl: 'https://flagcdn.com/w20/lv.png' },
    { id: 93, name: 'Líbano', flagUrl: 'https://flagcdn.com/w20/lb.png' },
    { id: 94, name: 'Lesoto', flagUrl: 'https://flagcdn.com/w20/ls.png' },
    { id: 95, name: 'Libéria', flagUrl: 'https://flagcdn.com/w20/lr.png' },
    { id: 96, name: 'Líbia', flagUrl: 'https://flagcdn.com/w20/ly.png' },
    {
      id: 97,
      name: 'Liechtenstein',
      flagUrl: 'https://flagcdn.com/w20/li.png',
    },
    { id: 98, name: 'Lituânia', flagUrl: 'https://flagcdn.com/w20/lt.png' },
    { id: 99, name: 'Luxemburgo', flagUrl: 'https://flagcdn.com/w20/lu.png' },
    {
      id: 100,
      name: 'Macedônia do Norte',
      flagUrl: 'https://flagcdn.com/w20/mk.png',
    },
    { id: 101, name: 'Madagascar', flagUrl: 'https://flagcdn.com/w20/mg.png' },
    { id: 102, name: 'Malawi', flagUrl: 'https://flagcdn.com/w20/mw.png' },
    { id: 103, name: 'Malásia', flagUrl: 'https://flagcdn.com/w20/my.png' },
    { id: 104, name: 'Maldivas', flagUrl: 'https://flagcdn.com/w20/mv.png' },
    { id: 105, name: 'Mali', flagUrl: 'https://flagcdn.com/w20/ml.png' },
    { id: 106, name: 'Malta', flagUrl: 'https://flagcdn.com/w20/mt.png' },
    { id: 107, name: 'Mauritânia', flagUrl: 'https://flagcdn.com/w20/mr.png' },
    { id: 108, name: 'Maurício', flagUrl: 'https://flagcdn.com/w20/mu.png' },
    { id: 109, name: 'México', flagUrl: 'https://flagcdn.com/w20/mx.png' },
    { id: 110, name: 'Micronésia', flagUrl: 'https://flagcdn.com/w20/fm.png' },
    { id: 111, name: 'Moldávia', flagUrl: 'https://flagcdn.com/w20/md.png' },
    { id: 112, name: 'Mônaco', flagUrl: 'https://flagcdn.com/w20/mc.png' },
    { id: 113, name: 'Mongólia', flagUrl: 'https://flagcdn.com/w20/mn.png' },
    { id: 114, name: 'Montenegro', flagUrl: 'https://flagcdn.com/w20/me.png' },
    { id: 115, name: 'Marrocos', flagUrl: 'https://flagcdn.com/w20/ma.png' },
    { id: 116, name: 'Moçambique', flagUrl: 'https://flagcdn.com/w20/mz.png' },
    { id: 117, name: 'Myanmar', flagUrl: 'https://flagcdn.com/w20/mm.png' },
    { id: 118, name: 'Namíbia', flagUrl: 'https://flagcdn.com/w20/na.png' },
    { id: 119, name: 'Nauru', flagUrl: 'https://flagcdn.com/w20/nr.png' },
    { id: 120, name: 'Nepal', flagUrl: 'https://flagcdn.com/w20/np.png' },
    {
      id: 121,
      name: 'Países Baixos',
      flagUrl: 'https://flagcdn.com/w20/nl.png',
    },
    {
      id: 122,
      name: 'Nova Zelândia',
      flagUrl: 'https://flagcdn.com/w20/nz.png',
    },
    { id: 123, name: 'Nicarágua', flagUrl: 'https://flagcdn.com/w20/ni.png' },
    { id: 124, name: 'Níger', flagUrl: 'https://flagcdn.com/w20/ne.png' },
    { id: 125, name: 'Nigéria', flagUrl: 'https://flagcdn.com/w20/ng.png' },
    { id: 126, name: 'Noruega', flagUrl: 'https://flagcdn.com/w20/no.png' },
    { id: 127, name: 'Omã', flagUrl: 'https://flagcdn.com/w20/om.png' },
    { id: 128, name: 'Paquistão', flagUrl: 'https://flagcdn.com/w20/pk.png' },
    { id: 129, name: 'Palau', flagUrl: 'https://flagcdn.com/w20/pw.png' },
    { id: 130, name: 'Palestina', flagUrl: 'https://flagcdn.com/w20/ps.png' },
    { id: 131, name: 'Panamá', flagUrl: 'https://flagcdn.com/w20/pa.png' },
    {
      id: 132,
      name: 'Papua Nova Guiné',
      flagUrl: 'https://flagcdn.com/w20/pg.png',
    },
    { id: 133, name: 'Paraguai', flagUrl: 'https://flagcdn.com/w20/py.png' },
    { id: 134, name: 'Peru', flagUrl: 'https://flagcdn.com/w20/pe.png' },
    { id: 135, name: 'Polônia', flagUrl: 'https://flagcdn.com/w20/pl.png' },
    { id: 136, name: 'Portugal', flagUrl: 'https://flagcdn.com/w20/pt.png' },
    { id: 137, name: 'Reino Unido', flagUrl: 'https://flagcdn.com/w20/gb.png' },
    {
      id: 138,
      name: 'República Centro-Africana',
      flagUrl: 'https://flagcdn.com/w20/cf.png',
    },
    {
      id: 139,
      name: 'República Dominicana',
      flagUrl: 'https://flagcdn.com/w20/do.png',
    },
    { id: 140, name: 'Romênia', flagUrl: 'https://flagcdn.com/w20/ro.png' },
    { id: 141, name: 'Ruanda', flagUrl: 'https://flagcdn.com/w20/rw.png' },
    { id: 142, name: 'Rússia', flagUrl: 'https://flagcdn.com/w20/ru.png' },
    {
      id: 143,
      name: 'São Cristóvão e Nevis',
      flagUrl: 'https://flagcdn.com/w20/kn.png',
    },
    { id: 144, name: 'São Marino', flagUrl: 'https://flagcdn.com/w20/sm.png' },
    {
      id: 145,
      name: 'São Tomé e Príncipe',
      flagUrl: 'https://flagcdn.com/w20/st.png',
    },
    {
      id: 146,
      name: 'São Vicente e Granadinas',
      flagUrl: 'https://flagcdn.com/w20/vc.png',
    },
    { id: 147, name: 'Santa Lúcia', flagUrl: 'https://flagcdn.com/w20/lc.png' },
    { id: 148, name: 'Senegal', flagUrl: 'https://flagcdn.com/w20/sn.png' },
    { id: 149, name: 'Sérvia', flagUrl: 'https://flagcdn.com/w20/rs.png' },
    { id: 150, name: 'Seychelles', flagUrl: 'https://flagcdn.com/w20/sc.png' },
    { id: 151, name: 'Singapura', flagUrl: 'https://flagcdn.com/w20/sg.png' },
    { id: 152, name: 'Síria', flagUrl: 'https://flagcdn.com/w20/sy.png' },
    { id: 153, name: 'Somália', flagUrl: 'https://flagcdn.com/w20/so.png' },
    { id: 154, name: 'Sri Lanka', flagUrl: 'https://flagcdn.com/w20/lk.png' },
    { id: 155, name: 'Sudão', flagUrl: 'https://flagcdn.com/w20/sd.png' },
    {
      id: 156,
      name: 'Sudão do Sul',
      flagUrl: 'https://flagcdn.com/w20/ss.png',
    },
    { id: 157, name: 'Suriname', flagUrl: 'https://flagcdn.com/w20/sr.png' },
    { id: 158, name: 'Suécia', flagUrl: 'https://flagcdn.com/w20/se.png' },
    { id: 159, name: 'Suíça', flagUrl: 'https://flagcdn.com/w20/ch.png' },
    { id: 160, name: 'Tajiquistão', flagUrl: 'https://flagcdn.com/w20/tj.png' },
    { id: 161, name: 'Tailândia', flagUrl: 'https://flagcdn.com/w20/th.png' },
    { id: 162, name: 'Timor-Leste', flagUrl: 'https://flagcdn.com/w20/tl.png' },
    { id: 163, name: 'Togo', flagUrl: 'https://flagcdn.com/w20/tg.png' },
    { id: 164, name: 'Tonga', flagUrl: 'https://flagcdn.com/w20/to.png' },
    {
      id: 165,
      name: 'Trinidad e Tobago',
      flagUrl: 'https://flagcdn.com/w20/tt.png',
    },
    { id: 166, name: 'Tunísia', flagUrl: 'https://flagcdn.com/w20/tn.png' },
    { id: 167, name: 'Turquia', flagUrl: 'https://flagcdn.com/w20/tr.png' },
    {
      id: 168,
      name: 'Turcomenistão',
      flagUrl: 'https://flagcdn.com/w20/tm.png',
    },
    { id: 169, name: 'Tuvalu', flagUrl: 'https://flagcdn.com/w20/tv.png' },
    { id: 170, name: 'Ucrânia', flagUrl: 'https://flagcdn.com/w20/ua.png' },
    { id: 171, name: 'Uganda', flagUrl: 'https://flagcdn.com/w20/ug.png' },
    { id: 172, name: 'Uruguai', flagUrl: 'https://flagcdn.com/w20/uy.png' },
    { id: 173, name: 'Uzbequistão', flagUrl: 'https://flagcdn.com/w20/uz.png' },
    { id: 174, name: 'Vanuatu', flagUrl: 'https://flagcdn.com/w20/vu.png' },
    { id: 175, name: 'Vaticano', flagUrl: 'https://flagcdn.com/w20/va.png' },
    { id: 176, name: 'Venezuela', flagUrl: 'https://flagcdn.com/w20/ve.png' },
    { id: 177, name: 'Vietnã', flagUrl: 'https://flagcdn.com/w20/vn.png' },
    { id: 178, name: 'Zâmbia', flagUrl: 'https://flagcdn.com/w20/zm.png' },
    { id: 179, name: 'Zimbábue', flagUrl: 'https://flagcdn.com/w20/zw.png' },
    {
      id: 180,
      name: 'São Bartolomeu',
      flagUrl: 'https://flagcdn.com/w20/bl.png',
    },
    {
      id: 181,
      name: 'Santa Helena, Ascensão e Tristão da Cunha',
      flagUrl: 'https://flagcdn.com/w20/sh.png',
    },
    {
      id: 182,
      name: 'Território Britânico do Oceano Índico',
      flagUrl: 'https://flagcdn.com/w20/io.png',
    },
    {
      id: 183,
      name: 'Ilhas Cayman',
      flagUrl: 'https://flagcdn.com/w20/ky.png',
    },
    {
      id: 184,
      name: 'Ilhas Cocos (Keeling)',
      flagUrl: 'https://flagcdn.com/w20/cc.png',
    },
    { id: 185, name: 'Ilhas Cook', flagUrl: 'https://flagcdn.com/w20/ck.png' },
    { id: 186, name: 'Ilhas Feroé', flagUrl: 'https://flagcdn.com/w20/fo.png' },
    {
      id: 187,
      name: 'Ilhas Georgianas do Sul e Sandwich do Sul',
      flagUrl: 'https://flagcdn.com/w20/gs.png',
    },
    {
      id: 188,
      name: 'Ilhas Heard e Ilhas McDonald',
      flagUrl: 'https://flagcdn.com/w20/hm.png',
    },
    {
      id: 189,
      name: 'Ilhas Malvinas',
      flagUrl: 'https://flagcdn.com/w20/fk.png',
    },
    {
      id: 190,
      name: 'Ilhas Marianas do Norte',
      flagUrl: 'https://flagcdn.com/w20/mp.png',
    },
    {
      id: 191,
      name: 'Ilhas Menores dos Estados Unidos',
      flagUrl: 'https://flagcdn.com/w20/us.png',
    },
    {
      id: 192,
      name: 'Ilhas Pitcairn',
      flagUrl: 'https://flagcdn.com/w20/pn.png',
    },
    {
      id: 193,
      name: 'Ilhas Virgens Americanas',
      flagUrl: 'https://flagcdn.com/w20/vi.png',
    },
    {
      id: 194,
      name: 'Ilhas Virgens Britânicas',
      flagUrl: 'https://flagcdn.com/w20/vg.png',
    },
    {
      id: 195,
      name: 'Samoa Americana',
      flagUrl: 'https://flagcdn.com/w20/as.png',
    },
  ];
  selectedCountry: { id: number; name: string; flagUrl: string } | null = null;
  onCountrySelected(country: { id: number; name: string; flagUrl: string }) {
    this.selectedCountry = country;
  }
  preventNegative(event: KeyboardEvent): void {
    if (event.key === '-' || event.key === '+' || event.key === 'e') {
      event.preventDefault();
    }
  }

  ngOnInit(): void {
    if (this.data) {
      this.empForm.patchValue(this.data.empForm);
    }
  }

  onFileSelected(event: Event): void {
    const input = event.target as HTMLInputElement;
    if (input.files && input.files.length > 0) {
      const file = input.files[0];
      const allowedTypes = ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];

      if (!allowedTypes.includes(file.type)) {
        this.toastService.error('Apenas arquivos PDF ou Word são permitidos.');
        return;
      }

      this.selectedFile = file;
      this.fileName = file.name;
      const reader = new FileReader();
      reader.onload = (e) => {
        this.imageUrl = (e.target?.result as string) || '';
      };
      reader.readAsDataURL(file);
    }}

  getErrorMessage(formControlName: string): string {
    if (this.empForm.get(formControlName)?.hasError('required')) {
      return 'Campo obrigatório';
    }
    if (this.empForm.get(formControlName)?.hasError('email')) {
      return 'E-mail inválido';
    }
    return '';
  }

  onFormSubmit() {
    if (this.empForm.valid) {
      const searchCriteria = {
        imo: this.empForm.value.imo,
        dataInicio: this.empForm.value.dataInicio,
        dataFim: this.empForm.value.dataFim,
      };
      console.log('Search Criteria:', searchCriteria);
      this._empService.searchNavios(searchCriteria).subscribe({
        next: (val: any) => {
          this.toastService.success('Busca realizada com sucesso');
          this._dialogRef.close(true);
        },
        error: (err: any) => {
          console.error(err);
        }
      });
    }
  }
}
