import { HttpClient, HttpErrorResponse, HttpParams } from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, tap } from 'rxjs/operators';
import { AsyncValidatorFn, AbstractControl, ValidationErrors, Validators } from '@angular/forms';
import { map} from 'rxjs/operators';
import { Injectable } from '@angular/core';
import { of } from 'rxjs';
import { environment } from '../../../environments/.env'; // Importa o environment

@Injectable({
  providedIn: 'root'
})
export class BercosService {
  users:any[]=[];

  private apiUrl = environment.API_URL + '/api/bercos';


  constructor(private _http: HttpClient) {}



  addEmployee(data: any): Observable<any> {
    return this._http.post(this.apiUrl, data).pipe(
      tap((res: any) => {
        console.log(res);
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  updateEmployee(id: number, data: any): Observable<any> {
    return this._http.put(`${this.apiUrl}/${id}`, data).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      }));
  }


  getEmployeeList(pageIndex: number, pageSize: number): Observable<any> {
    let params = new HttpParams()
      .set('page', pageIndex.toString())
      .set('size', pageSize.toString());

    return this._http.get<any>(this.apiUrl, { params }).pipe(
      tap((res: any) => {
        console.log(res);
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  getEmployeeListbyId(id: number): Observable<any> {
    return this._http.get(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  deleteEmployee(id: number): Observable<any> {
    return this._http.delete(`${this.apiUrl}/${id}`).pipe(
      tap((res: any) => {
        this.users = res;
      }),
      catchError(error => {
        return throwError(error);
      }));
  }

  getBercosListSemPaginacao(): Observable<any> {
    return this._http.get<any>(`${this.apiUrl}/sem-paginacao`).pipe(
      tap((res: any) => {
        console.log('Lista completa de berços:', res);
      }),
      catchError(error => {
        return throwError(error);
      })
    );
  }

  searchBerco(data: any): Observable<any> {
    let params = new HttpParams();

    // Adiciona os parâmetros de forma condicional (apenas se existirem)
    if (data.categoria) {
      params = params.set('categoria', data.categoria);
    }
    if (data.nome) {
      params = params.set('nome', data.nome);
    }

    // Faz a requisição GET com os parâmetros
    return this._http.get<any>(`${this.apiUrl}/custom`, { params }).pipe(
      tap((res: any) => {
        console.log('Resultado recebido:', res);
        sessionStorage.setItem("bercosSearch", JSON.stringify(res));
      }),
      catchError(error => {
        console.error('Erro ao buscar dados:', error);
        return throwError(error);
      })
    );
  }
  getAllAceitesSemPaginacao(): Observable<any[]> {
  return this._http.get<any>(`${this.apiUrl}/sem-paginacao`).pipe(
    map((res: any) => {
      // Ajuste conforme a estrutura do seu backend
      return res._embedded?.bercoResponseList || [];
    })
  );
}
}
