
---

⚓ **Automatização do Aceite Técnico de Navios** ⚓

Uma aplicação Front-End desenvolvida com o framework **Angular (JavaScript)** para **facilitar** e **otimizar** o processo de aceite técnico de embarcações.

---
⚓ **COMANDOS DOCKER** ⚓
1. docker build -t aceite-navio .
2. docker run -d -p 4200:80 --name login-container aceite-navio

### 🎯 **Descrição**

Este projeto é uma **aplicação web** que permite aos usuários gerenciar completamente o processo de aceite técnico de navios. Com ele, você pode **criar**, **visualizar**, **editar** e **deletar** tarefas relacionadas ao processo de aceitação, proporcionando um **fluxo de trabalho eficiente** e um acompanhamento detalhado das atividades necessárias para a aprovação técnica das embarcações. 

---

### 🚀 **Instalação**

1. **Clone o repositório**:  
   ```bash
   git clone https://github.com/Reirenan/Projeto_Angular_App.git
   ```

2. **Navegue até o diretório do projeto**:  
   ```bash
   cd Projeto_Angular_App
   ```

3. **Instale as dependências necessárias**:  
   ```bash
   npm install --legacy-peer-deps
   ```

4. **Inicie o servidor de desenvolvimento**:  
   ```bash
   ng serve
   ```

5. **Acesse a aplicação** no seu navegador:  
   🌐 [http://localhost:4200](http://localhost:4200)

---

### 🌱 **Passos para Criar uma Nova Branch no Git**

1. **Atualize o repositório local** (opcional, mas recomendado):
   Antes de criar uma nova branch, é uma boa prática garantir que o repositório local esteja atualizado 
   com as mudanças mais recentes da branch principal (geralmente `main` ou `master`).

   ```bash
   git checkout main
   git pull origin main
   ```

2. **Crie uma nova branch**:
   Escolha um nome para a nova branch e crie-a:

   ```bash
   git checkout -b MinhaNovaBranch
   ```

3. **Verifique se está na nova branch**:
   Após criar a branch, verifique se você está nela.

   ```bash
   git branch
   ```

   Isso deve mostrar um asterisco (`*`) ao lado da branch atual.

4. **Faça suas alterações**:
   Realize as alterações necessárias nos arquivos do projeto.

5. **Adicione os arquivos modificados para o commit**:
   Depois de fazer as alterações, adicione os arquivos que deseja incluir no commit:

   ```bash
   git add .
   ```

   Ou adicione arquivos específicos:

   ```bash
   git add nome_do_arquivo
   ```

6. **Faça o commit das suas alterações**:
   Agora, faça o commit das suas alterações com uma mensagem descritiva:

   ```bash
   git commit -m 'Comentário do commit da minha nova branch'
   ```

7. **Envie a branch para o repositório remoto**:
   Envie a nova branch para o repositório remoto, criando um link entre sua branch local e a remota:

   ```bash
   git push --set-upstream origin MinhaNovaBranch
   ```

8. **Crie um Pull Request** (opcional, dependendo do fluxo de trabalho):
   Se o repositório usa Pull Requests (PRs) para revisar e integrar o código, você pode criar um PR na interface do GitHub ou outro serviço de hospedagem de repositórios.

   - No GitHub, vá até o repositório, e você verá a opção de criar um PR a partir da nova branch.
   
---

Esses passos cobrem desde a criação da branch até o envio para o repositório remoto. Dependendo do fluxo de trabalho do projeto, a criação de um Pull Request pode ser necessária para a revisão de código antes de realizar o merge com a branch principal.

Agora, a aplicação deve estar rodando localmente. Se precisar de mais informações ou orientações, estou à disposição! 😉


