import { ChangeDetectorRef, Component, Input, OnInit, computed, signal } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MatListModule } from '@angular/material/list';
import { MatIconModule } from '@angular/material/icon';
import { RouterModule } from '@angular/router';
import { JwtDecoderService } from '../../jwt-decoder.service';
import { AuthService } from '../../auth.service';
import { jwtDecode } from 'jwt-decode';


export type MenuItem = {
  icon: string;
  label: string;
  route?: string;
  role?:string;
}
@Component({
  selector: 'app-custom-sidenav',
  standalone: true,
  imports: [CommonModule, MatListModule, MatIconModule, RouterModule],
  templateUrl: './custom-sidenav.component.html',
  styleUrls: ['./custom-sidenav.component.scss']
})
export class CustomSidenavComponent implements OnInit{
  user: any;
  sidenavWidth = '250px';
  authTokenPresent = false;

  constructor(
    private jwtDecoderService: JwtDecoderService,
    private authService: AuthService,
    private cdr: ChangeDetectorRef
  ) {}

  ngOnInit() {
    this.authService.authToken$.subscribe(isLoggedIn => {
      this.authTokenPresent = isLoggedIn;
      if (this.authTokenPresent) {
        const token = sessionStorage.getItem('accessToken')!;
        this.user = jwtDecode(token);
        const isExpired = 
        this.user &&  this.user.exp?  this.user.exp < Date.now()/1000:false
        if(isExpired){
          sessionStorage.removeItem('accessToken');
        }
        this.user = this.jwtDecoderService.decodeToken(token);      
        console.log(this.user);  
      }
      this.cdr.detectChanges(); 
    });
  }
  sideNavCollapsed = signal(false);
  @Input() set collapsed(val: boolean) {
    this.sideNavCollapsed.set(val);
  }
  menuItems = signal<MenuItem[]>([
    {
      icon: 'dashboard',
      label: 'Dashboard',
      route: 'dashboard',
      role: 'COMPANY',
    },
    {
      icon: 'directions_boat',
      label: 'Navios',
      route: 'navio',
      role: 'CANDIDATE',
    },
    {
      icon: 'calendar_today',
      label: 'Aceites',
      route: 'aceite',
      role: 'CANDIDATE'
    },
    {
      icon: 'dock',
      label: 'Berços',
      route: 'berco',
      role: 'CANDIDATE'
    },
    {
      icon:'block',
      label:'Black List',
      route:'black-list',
      role:'COMPANY'
    },
    {
      icon: 'groups',
      label: 'Usuários',
      route: 'users',
      role: 'COMPANY'
    }
  ]);

  profilePicSize = computed(() => (this.sideNavCollapsed() ? '32' : '100'));
}
