import { ChangeDetectorRef, Component, OnInit } from '@angular/core';
import { AuthService } from './auth.service';
import { JwtDecoderService } from './jwt-decoder.service';
import { Router, RouterLink, RouterOutlet } from '@angular/router';
import { MatToolbarModule } from '@angular/material/toolbar';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import { MatSidenavModule } from '@angular/material/sidenav';
import { CustomSidenavComponent } from './components/custom-sidenav/custom-sidenav.component';
import { CommonModule } from '@angular/common';
import { jwtDecode } from 'jwt-decode';
import {MatMenuModule} from '@angular/material/menu';

@Component({
  selector: 'app-root',
  standalone: true,
  imports: [
    RouterLink, RouterOutlet, CommonModule,
    MatToolbarModule, MatButtonModule, MatIconModule,
    MatSidenavModule, CustomSidenavComponent,MatIconModule,MatMenuModule
  ],
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {
  decodedToken: any;
  collapsed = false;
  sidenavWidth = '250px';
  authTokenPresent = false;
  token_valido = false;

  constructor(
    private jwtDecoderService: JwtDecoderService,
    private authService: AuthService,
    private cdr: ChangeDetectorRef,
    private router:Router
  ) {}

  ngOnInit() {
    this.authService.authToken$.subscribe(isLoggedIn => {
      this.authTokenPresent = isLoggedIn;
      if (this.authTokenPresent) {
        const token = sessionStorage.getItem('accessToken')!;
        if (token) {
          this.decodedToken = jwtDecode(token);
          const isExpired = this.isTokenExpired(this.decodedToken);
          if (isExpired) {
            sessionStorage.removeItem('accessToken');
          } else {
            this.decodedToken = this.jwtDecoderService.decodeToken(token);      
            if (this.decodedToken.role != null) {
              this.token_valido = true;
            }  
          }
        }
      }
      this.cdr.detectChanges();
    });
  }
  logout() {
    // Remove o token do armazenamento da sessão
    sessionStorage.removeItem('accessToken');
    
    // Atualiza o estado de autenticação para falso
    this.authTokenPresent = false;
    this.token_valido = false;
    
    // Redireciona para a página de login ou outra rota
    this.router.navigate(['/']);
    
    // Detecta mudanças para atualizar o componente
    this.cdr.detectChanges();
  }
  
  isTokenExpired(token: any): boolean {
    if (!token || !token.exp) {
      return true;
    }
    return token.exp < Date.now() / 1000;
  }

  toggleCollapsed() {
    this.collapsed = !this.collapsed;
    this.sidenavWidth = this.collapsed ? '65px' : '250px';
    this.cdr.detectChanges();
  }
}
